﻿using Hims.Shared.Dapper.Attributes;
using System.ComponentModel.DataAnnotations;

namespace Hims.Domain.Entities
{
    /// <summary>
    /// The account.
    /// </summary>
    public class LocationFloorMap
    {
        /// <summary>
        /// Gets or sets the location floor map identifier.
        /// </summary>
        /// <value>
        /// The location floor map identifier.
        /// </value>
        [Key, Identity]
        public int LocationFloorMapId { get; set; }

        /// <summary>
        /// Gets or sets the location identifier.
        /// </summary>
        /// <value>
        /// The location identifier.
        /// </value>
        public int LocationId { get; set; }

        /// <summary>
        /// Gets or sets the floor identifier.
        /// </summary>
        /// <value>
        /// The floor identifier.
        /// </value>
        public int FloorId { get; set; }
    }
}