﻿namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The coupon.
    /// </summary>
    public class ProgressReportDiet
    {
        /// <summary>
        /// Gets or sets the progress report diet id.
        /// </summary>
        [Key, Identity]
        public int ProgressReportDietId { get; set; }

        /// <summary>
        /// Gets or sets the progress report id.
        /// </summary>
        public int ProgressReportId { get; set; }

        /// <summary>
        /// Gets or sets the meal type id.
        /// </summary>
        public int? MealTypeId { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        [IgnoreUpdate]
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        [IgnoreUpdate]
        public DateTime? CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the duration.
        /// </summary>
        public int Duration { get; set; }

        /// <summary>
        /// Gets or sets the medication duration type id.
        /// </summary>
        public int MedicationDurationTypeId { get; set; }

        /// <summary>
        /// Gets or sets the start date.
        /// </summary>
        public DateTime StartDate { get; set; }

        /// <summary>
        /// Gets or sets the end date.
        /// </summary>
        public DateTime EndDate { get; set; }

        /// <summary>
        /// Gets or sets the stop date.
        /// </summary>
        public DateTime? StopDate { get; set; }

        /// <summary>
        /// Gets or sets the stop reason.
        /// </summary>
        public string StopReason { get; set; }

        /// <summary>
        /// Gets or sets the stop reason.
        /// </summary>
        public string DietInstructions { get; set; }

        /// <summary>
        /// Gets or sets the is morning.
        /// </summary>
        public bool IsMorning { get; set; }

        /// <summary>
        /// Gets or sets the is afternoon.
        /// </summary>
        public bool IsAfternoon { get; set; }

        /// <summary>
        /// Gets or sets the is night.
        /// </summary>
        public bool IsNight { get; set; }
    }
}
