﻿using Hims.Shared.Dapper.Attributes;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Text;

namespace Hims.Domain.Entities
{
    public class ProviderAvailabilityForMultipleDays
    {
        /// <summary>
        /// Gets or sets the provider location id.
        /// </summary>
        [Key, Identity]
        public int? ProviderAvailabilityId { get; set; }

        /// <summary>
        /// Gets or sets the provider id.
        /// </summary>
        public int ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the location id.
        /// </summary>
        public int LocationId { get; set; }

        /// <summary>
        /// Gets or sets the consultation duration.
        /// </summary>
        public int? ConsultationTypeId { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        [IgnoreUpdate]
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        [IgnoreUpdate]
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the start date.
        /// </summary>
        public string? StartDate { get; set; }

        /// <summary>
        /// Gets or sets the end date.
        /// </summary>
        public string? EndDate { get; set; }

        /// <summary>
        /// Gets or sets the specialization id.
        /// </summary>
        public int? SpecializationId { get; set; }

        /// <summary>
        /// Gets or sets the available days.
        /// </summary>
        public string AvailableDay { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the start date.
        /// </summary>
        public string? StartTime { get; set; }

        /// <summary>
        /// Gets or sets the end date.
        /// </summary>
        public string? EndTime { get; set; }

        /// <summary>
        /// Gets or sets the free follow up days.
        /// </summary>
        public int? FreeFollowUpDays { get; set; }

        /// <summary>
        /// Gets or sets the fee followup days limit.
        /// </summary>
        public int? FreeFollowUpDaysLimit { get; set; }

        /// <summary>
        /// Gets or sets the available date.
        /// </summary>
        public DateTime AvailableDate { get; set; }

        /// <summary>
        /// Gets or sets the start date.
        /// </summary>
        public string? LeaveStartDate { get; set; }

        /// <summary>
        /// Gets or sets the end date.
        /// </summary>
        public string? LeaveEndDate { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool IsLeave { get; set; }

        /// <summary>
        /// Gets or sets the no of new patient.
        /// </summary>
        public int? NoOfNewPatient { get; set; }
        /// <summary>
        /// Gets or sets the no of new patient.
        /// </summary>
        public int? NoOfOfflinePatient { get; set; }

        /// <summary>
        /// Gets or sets the duration.
        /// </summary>
        public int? SpecializationDuration { get; set; }
    }
}
