﻿using Hims.Shared.Dapper.Attributes;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;

namespace Hims.Domain.Entities.Vendors
{
    /// <summary>
    /// The product for quotation detail.
    /// </summary>
    [Table("ProductForQuotationDetail", Schema = "vendors")]
    public class ProductForQuotationDetail
    {
        /// <summary>
        /// Gets or sets the product for quotation detail identifier.
        /// </summary>
        /// <value>
        /// The product for quotation detail identifier.
        /// </value>
        [Key,Identity]
        public long ProductForQuotationDetailId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy product approval identifier.
        /// </summary>
        /// <value>
        /// The pharmacy product approval identifier.
        /// </value>
        public long PharmacyProductApprovalId { get; set; }

        /// <summary>
        /// Gets or sets the product for quotation header identifier.
        /// </summary>
        /// <value>
        /// The product for quotation header identifier.
        /// </value>
        public long ProductForQuotationHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the tender status identifier.
        /// </summary>
        /// <value>
        /// The tender status identifier.
        /// </value>
        public int TenderStatusId { get; set; }
    }
}
