﻿namespace Hims.Domain.Services
{
    using System.Threading.Tasks;

    /// <summary>
    /// The AccountCredential interface.
    /// </summary>
    public interface IAccountCredentialService
    {
        /// <summary>
        /// The check account credentials async.
        /// </summary>
        /// <param name="accountId">
        /// The account id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> CheckAsync(int accountId);

        /// <summary>
        /// The create credential async.
        /// </summary>
        /// <param name="accountId">
        /// The account id.
        /// </param>
        /// <param name="password">
        /// The password.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> CreateAsync(int accountId, string password);

        /// <summary>
        /// The create credential async.
        /// </summary>
        /// <param name="userName">
        /// The userName.
        /// </param>
        /// <param name="roleId">
        /// The roleId.
        ///  /// </param>
        /// <param name="password">
        /// The password.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> PatientPasswordCreateAsync(string userName, int? roleId, string password);

        /// <summary>
        /// The create credential async.
        /// </summary>
        /// <param name="accountId">
        /// The account id.
        /// </param>
        /// <param name="password">
        /// The password.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> CreatePasswordAsync(int accountId, string password);
    }
}