﻿namespace Hims.Domain.Services
{
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Shared.EntityModels;
    using Shared.UserModels.Filters;
    using Shared.UserModels.Admission;
    using Hims.Shared.UserModels;
    using Hims.Domain.Entities;

    /// <summary>
    /// The Appointment Service interface.
    /// </summary>
    public interface IAdmissionService
    {
        /// <summary>
        /// Fetches the priorities asynchronous.
        /// </summary>
        /// <returns></returns>
        Task<IEnumerable<PriorityViewModel>> FetchPrioritiesAsync();

        /// <summary>
        /// Cancels the asynchronous.
        /// </summary>
        /// <param name="admissionId">The admission identifier.</param>
        /// <returns></returns>
        Task<int> CancelAsync(int admissionId);

        /// <summary>
        /// The fetch async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<AdmissionModel>> FetchAsync(AdmissionFilterModel model);

        /// <summary>
        /// The find async.
        /// </summary>
        /// <param name="admissionId"></param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<AdmissionModel> FindAsync(int admissionId);
        /// <summary>
        /// The find async.
        /// </summary>
        /// <param name="admissionId"></param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<FinalBillModel> FindFinalBillAsync(int finalBillId);

        /// <summary>
        /// The add admission async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> AddAdmissionAsync(ModifyAdmissionModel model);

        /// <summary>
        /// The fetch wards async.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<BedManagementModel>> FetchWardsAsync(int locationId);

        /// <summary>
        /// The fetch admission for audit log async.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<AdmissionModel> FetchAdmissionInfo(int admissionId);

        /// <summary>
        /// The fetch rooms async.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<BedManagementModel>> FetchRoomsAsync(int? wardId, int? chargeCategoryId, int? locationId);

        /// <summary>
        /// The fetch beds async.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<BedManagementModel>> FetchBedsAsync(BedManagementModel model);

        /// <summary>
        /// Raises the bed change request asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> RaiseBedChangeRequestAsync(AdmissionBedChangeRequestModel model);
        /// <summary>
        /// The add admission async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> AddAdmissionTransferRequest(AdmissionTransferRequestModel model);
        /// <summary>
        /// The fetch beds async.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<AdmissionTransferRequestModel>> FetchAdmissionTransferRequest(AdmissionTransferRequestModel model);
        /// <summary>
        /// The fetch beds async.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> AcceptTransferRequest(AdmissionTransferRequestModel model);
        /// <summary>
        /// The fetch beds async.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> RejectAdmissionTransferRequest(AdmissionTransferRequestModel model);
    }
}
