﻿namespace Hims.Domain.Services
{
    using System.Collections.Generic;
    using System.Threading.Tasks;

    using Shared.EntityModels;
    using Shared.UserModels.Filters;

    /// <summary>
    /// The AppointmentTransactionService interface.
    /// </summary>
    public interface IAppointmentTransactionService
    {
        /// <summary>
        /// The fetch async.
        /// </summary>
        /// /// <param name="appointmentId">
        /// The id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<AppointmentTransactionModel> FetchAsync(int appointmentId);

        /// <summary>
        /// The fetch async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<AppointmentTransactionModel>> FetchAsync(AppointmentTransactionFilterModel model);

        /// <summary>
        /// The fetch provider transactions async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<AppointmentTransactionModel>> FetchProviderTransactionsAsync(AppointmentTransactionFilterModel model);

        /// <summary>
        /// The fetch async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<RefundModel>> FetchRefundAsync(AppointmentTransactionFilterModel model);

        /// <summary>
        /// The find transaction details async.
        /// </summary>
        /// <param name="appointmentTransactionId">
        /// The appointment transaction id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<string> FindTransactionDetailsAsync(int appointmentTransactionId);

        /// <summary>
        /// The fetch async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<ProviderBankAccountModel>> FetchPayoutAsync(AppointmentTransactionFilterModel model);

        /// <summary>
        /// The fetch async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<AppointmentTransactionModel>> FetchPayoutDetailsAsync(AppointmentTransactionFilterModel model);

        /// <summary>
        /// The find settlement details async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<SettlementDetailModel>> FindSettlementDetailsAsync(SettlementFilterModel model);

        /// <summary>
        /// The fetch appointments details async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<AppointmentTransactionModel>> FetchAppointmentsDetailsAsync(AppointmentTransactionFilterModel model);

        /// <summary>
        /// The add async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<int>> AddAsync(IEnumerable<PaymentDocumentModel> model);

        /// <summary>
        /// The fetch payment async.
        /// </summary>
        /// <param name="model">
        ///     The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<PaymentDocumentModel>> FetchPaymentAsync(PaymentDocumentFilterModel model);

        /// <summary>
        /// The delete async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> DeleteAsync(PaymentDocumentModel model);

        /// <summary>
        /// The get async.
        /// </summary>
        /// <param name="id">
        /// The id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<PaymentDocumentModel> GetAsync(int id);

        /// <summary>
        /// The update async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> UpdateAsync(PaymentDocumentModel model);

        /// <summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<string> GetPreviousVoucherNumberAsync();

        /// <summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<string> GetVoucherNumber();

        /// <summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<string> GetATransactionId();
    }
}
