﻿namespace Hims.Domain.Services
{
    using System.Threading.Tasks;
    using Shared.EntityModels;
    using Shared.Library;
    using Shared.Library.Enums;
    using Shared.UserModels;
    using Hims.Shared.Library.Helpers;

    /// <summary>
    /// The Homeopathy Service interface.
    /// </summary>
    public interface IHomeopathyService
    {
        /// <summary>
        /// The add alt async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<CommonResponse> AddAltAsync(HomeopathyEncounterModifyModel model);

        /// <summary>
        /// The update alt async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<CommonResponse> UpdateAltAsync(HomeopathyEncounterModifyModel model);

        /// <summary> The fetch async.</summary>
        /// <param name="appointmentId"> The appointment id.</param>
        /// <param name="type"> The type.</param>
        /// <returns>The <see cref="Task"/>.</returns>
        Task<HomeopathyResource> FetchAsync(int appointmentId, HomeopathyType type);

        /// <summary>
        /// The find async.
        /// </summary>
        /// <param name="homeopathyId">
        /// The Homeopathy Id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<HomeopathyModel> FindAsync(int homeopathyId);

        /// <summary>
        /// The add async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> AddAsync(HomeopathyEncounterModifyModel model);

        /// <summary>
        /// The update async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> UpdateAsync(HomeopathyEncounterModifyModel model);

        /// <summary>
        /// The delete async.
        /// </summary>
        /// <param name="homeopathyId">
        /// The homeopathy id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> DeleteAsync(int homeopathyId);

        /// <summary>
        /// The find full transcript async.
        /// </summary>
        /// <param name="appointmentId">
        /// The appointment id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<HomeopathyFullTranscriptModel> FindFullTranscriptAsync(int appointmentId);
    }
}
