﻿namespace Hims.Domain.Services
{
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Hims.Domain.Entities;
    using Hims.Shared.EntityModels;
    using Hims.Shared.Library.Enums;
    using Hims.Shared.Library.Helpers;
    using Hims.Shared.UserModels;
    using Hims.Shared.UserModels.Labs;
    using Hims.Shared.UserModels.OBEncounter;
    //using Ob = Hims.Shared.UserModels.OBEncounter;
    using ob = Shared.UserModels.OBEncounter;
    using obEncounter = Shared.UserModels.OBEncounter;
    /// <summary>
    /// The InternalMedicineService interface.
    /// </summary>
    public interface IOBEncounterService
    {
        /// <summary>
        /// Finds the asynchronous.
        /// </summary>
        /// <param name="appointmentId">The appointment identifier.</param>
        /// <param name="isAdmission">if set to <c>true</c> [is admission].</param>
        /// <returns></returns>
        Task<ObEncounterModel> FindAsync(int appointmentId, bool isAdmission);


        /// <summary>
        /// The add ob encounter async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<CommonResponse> AddAsync(ob.InsertModel model);

        /// <summary>
        /// The update alt async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<CommonResponse> UpdateAsync(ob.InsertModel model);

        /// <summary>
        /// Finds the dashboard asynchronous.
        /// </summary>
        /// <param name="appointmentId">The appointment identifier.</param>
        /// <param name="type">The type.</param>
        /// <param name="isAdmission">if set to <c>true</c> [is admission].</param>
        /// <returns></returns>
        Task<obEncounter.ObEncounterResource> FindDashboardAsync(int appointmentId, OBEncounterType type, bool isAdmission);


        /// <summary>
        /// The find full transcript async.
        /// </summary>
        /// <param name="appointmentId">
        /// The appointment id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<ObEncounterFullTranscriptModel> FindFullTranscriptAsync(int appointmentId);

        /// <summary>
        /// The find full transcript async.
        /// </summary>
        /// <param name="appointmentId">
        /// The appointment id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<ObEncounterFullTranscriptModel> FindPrescriptionAsync(int appointmentId);

        /// <summary>
        /// The add anc card.
        /// </summary>
        /// <param name="model">
        /// The anc model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> AddAncAsync(ANCCardGenerationModel model, string locationId);
        /// <summary>
        /// The fetch anc card.
        /// </summary>
        /// <param name="patientId">
        /// The patient id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<ANCCardGenerationModel> FetchAncCardAsync(ANCCardGenerationModel model);
        Task<ANCCardGenerationModel> FetchPatientAncCardAsync(ANCCardGenerationModel model);
        Task<int> ModifyStatusAsync(int patientId);

        /// <summary>
        /// The fetch anc card.
        /// </summary>
        /// <param name="patientId">
        /// The patient id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<OrderPrescriptions>> FetchOrderPrescription(int patientId, string encounterType);
        /// <summary>
        /// The modify status.
        /// </summary>
        /// <param name="appointmentId">
        /// The appointment id.
        /// </param>
        Task<int> ModifyEncounterStatus(int appointmentId);

        /// <summary>
        /// The fetch icd values.
        /// </summary>
       
        Task<IEnumerable<ICDValuesModel>> FetchICDValues(ICDValuesModel model);

        /// <summary>
        /// Finds the asynchronous.
        /// </summary>
        /// <param name="appointmentId">The appointment identifier.</param>
        /// <param name="isAdmission">if set to <c>true</c> [is admission].</param>
        /// <returns></returns>
        Task<ObEncounterResource> FindOb(int appointmentId, OBEncounterType type, bool isAdmission);

        /// <summary>
        /// The find the appointment exist in obencounter.
        /// </summary>

        Task<int> getApppointmentId(int appointmentId, bool isAdmission);


        /// <summary>
        /// The fetch cross consulation.
        /// </summary>

        Task<IEnumerable<ReferralFormModel>> FetchCrossConsultation(ReferralFormModel model);


        /// <summary>
        /// The fetch lab booking header.
        /// </summary>

        Task<IEnumerable<LabBookingModel>> fetchlabBookingHeader(int patientId);
        /// <summary>
        /// The fetch visit number of patient.
        /// </summary>
        Task<int> FetchVisitNoAsync(int patientId);

        Task<int> InsertReferralForm(ReferralFormModel model);

        /// <summary>
        /// The fetch anc card.
        /// </summary>
        /// <param name="patientId">
        /// The patient id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<ObEncounterModel>> FetchFullTrascriptList(int patientId);
        /// <summary>
        /// The fetch lab parameters.
        /// </summary>
        Task<IEnumerable<LabParameters>> FetchLabParameters(int labMainDetailId);

        /// <summary>
        /// Finds the asynchronous.
        /// </summary>
        /// <param name="appointmentId">The appointment identifier.</param>
        /// <param name="isAdmission">if set to <c>true</c> [is admission].</param>
        /// <returns></returns>
        Task<ObEncounterModel> FindEncounterDataAsync(int appointmentId, bool isAdmission);


    }
}
