﻿namespace Hims.Domain.Services
{
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Shared.EntityModels;

    /// <summary>
    /// The PatientDeviceDetailsService interface.
    /// </summary>
    public interface IPatientDeviceDetailsService
    {
        /// <summary>
        /// The fetch async.
        /// </summary>
        /// <param name="appointmentId">
        /// The appointment id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<PatientDeviceDetailsModel>> FetchAsync(int appointmentId);

        /// <summary>
        /// The insert async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> InsertAsync(PatientDeviceDetailsModel model);
    }
}