﻿namespace Hims.Domain.Services
{
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Shared.EntityModels;
    using Hims.Shared.UserModels.Filters;

    /// <summary>
    /// the provider encounter service interface
    /// </summary>
    public interface IProviderEncounterService
    {
        /// <summary>
        /// The Add async
        /// </summary>
        /// <param name="model">
        /// The model
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> AddAsync(ProviderEncounterModel model);

        /// <summary>
        /// The update async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> UpdateAsync(ProviderEncounterModel model);

        /// <summary>
        /// The fetch async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<ProviderEncounterModel>> FetchAsync(ProviderEncounterFilterModel model);

        /// <summary>
        /// The fetch provider encounter async.
        /// </summary>
        /// <param name="providerId">
        /// The provider id.
        /// </param>
        /// <returns>
        /// The <see cref="ProviderEncounterModel"/>.
        /// </returns>
        ProviderEncounterModel FetchProviderEncounterAsync(int providerId);

        /// <summary>
        /// The fetch radiology value async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<RadiologyValueModel>> FetchRadiologyValueAsync(RadiologyValueFilterModel model);

        /// <summary>
        /// The fetch allergies async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<LookupValueModel>> FetchAllergiesAsync(LookUpValueFilterModel model);

        /// <summary>
        /// The fetch reactions async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<LookupValueModel>> FetchReactionsAsync(LookUpValueFilterModel model);

        /// <summary>
        /// The fetch hospitalizations async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<LookupValueModel>> FetchHospitalizationsAsync(LookUpValueFilterModel model);

        /// <summary>
        /// The fetch initials async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<LookupValueModel>> FetchInitialsAsync(LookUpValueFilterModel model);

        /// <summary>
        /// The fetch pcares async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<LookupValueModel>> FetchPCaresAsync(LookUpValueFilterModel model);

        /// <summary>
        /// The fetch sites async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<LookupValueModel>> FetchSitesAsync(LookUpValueFilterModel model);

        /// <summary>
        /// The fetch vaccine async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<LookupValueModel>> FetchVaccinesAsync(LookUpValueFilterModel model);

        /// <summary>
        /// The delete provider encounter async.
        /// </summary>
        /// <param name="providerGeneralAdviceId">
        /// The provider General Advice Id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> DeleteProviderEncounterAsync(int providerGeneralAdviceId);

        /// <summary>
        /// The unassign async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> UnAssignAllGeneralAdvicesAsync(ProviderEncounterModel model);

        /// <summary>
        /// The unassign async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> UnAssignAllIcdCodeAsync(ProviderEncounterModel model);

        /// <summary>
        /// The unassign async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> UnAssignAllLabOrderValueAsync(ProviderEncounterModel model);

        /// <summary>
        /// The unassign async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> UnAssignAllRadiologyValueAsync(ProviderEncounterModel model);

        /// <summary>
        /// The unassign all allergies async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> UnAssignAllAllergiesAsync(ProviderEncounterModel model);

        /// <summary>
        /// The unassign all reactions async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> UnAssignAllReactionsAsync(ProviderEncounterModel model);

        /// <summary>
        /// The unassign all hospitalization async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> UnAssignAllHospitalizationAsync(ProviderEncounterModel model);

        /// <summary>
        /// The unassign all initials async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> UnAssignAllInitialsAsync(ProviderEncounterModel model);

        /// <summary>
        /// The unassign all p care async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> UnAssignAllPCareAsync(ProviderEncounterModel model);

        /// <summary>
        /// The unassign all p care async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> UnAssignAllSiteAsync(ProviderEncounterModel model);

        /// <summary>
        /// The unassign all p care async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> UnAssignAllVaccineAsync(ProviderEncounterModel model);

        /// <summary>
        /// The update async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> UpdateLookupValueAsync(LookupValueModel model);
    }
}
