﻿using Dapper;
using Hims.Domain.Entities;
using Hims.Domain.Repositories.UnitOfWork;
using Hims.Domain.Services;
using Hims.Shared.UserModels;
using Hims.Shared.UserModels.Slots;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Hims.Infrastructure.Services
{
    public class CallHistoryServices : ICallHistoryDataService
    {
        /// <summary>
        /// The unit of work.
        /// </summary>
        private readonly IUnitOfWork unitOfWork;

        /// <inheritdoc cref="IBedService" />
        public CallHistoryServices(IUnitOfWork unitOfWork) => this.unitOfWork = unitOfWork;
        public async Task<int> AddAsync(CallHistory model)
        {
            //var checkIf = await this.unitOfWork.Current.QueryFirstOrDefaultAsync<int>($@"SELECT COUNT(""MobileNumber"") FROM ""CallHistory"" WHERE ""MobileNumber"" = '{model.MobileNumber}'");
            //if (checkIf > 0)
            //{
            //    return -1;
            //}

            try
            {
                var problem = new CallHistory
                {
                    IsActive = true,
                    MobileNumber = model.MobileNumber,
                    FirstName = model.FirstName,
                    LastName = model.LastName,
                    Type = model.Type,
                    Comments = model.Comments,
                    Status = model.Status,
                    CallStart = model.CallStart,
                    CallEnd = model.CallEnd,
                    CallDuration = model.CallDuration,
                    CreatedBy = model.CreatedBy,
                    CreatedDate = DateTime.Now,
                };
                return await this.unitOfWork.CallHistorys.InsertAsync(problem);
            }
            catch (Exception ex) { }

            return 0;

        }

        public Task<int> DeleteAsync(int Id)
        {
            var query = $@"DELETE FROM ""CallHistory"" WHERE ""Id""= {Id}";
            return this.unitOfWork.Current.ExecuteAsync(query);
        }

        public async Task<IEnumerable<Call_HistoryModel>> FetchAsync(Call_HistoryModel model)
        {
            var query = "";
            if (model.Type != 0)
            {
                query = $@"Select Acc.""FullName"",CH.""MobileNumber"", CH.""FirstName"", CH.""CreatedDate"", CH.""Comments"", 
                        CH.""CallStart"", CH.""CallEnd"",CH.""LastName"", CH.""Type""
                        From ""CallHistory"" CH
                        Join ""Account"" Acc On CH.""CreatedBy"" = Acc.""AccountId"" WHERE ""Type""= {model.Type}
                        order by CH.""Id"" desc";

            }
            else { query = $@"Select CH.""Id"",CH.""CallDuration"",Acc.""FullName"",CH.""MobileNumber"", CH.""FirstName"", CH.""CreatedDate"", CH.""Comments"", 
                            CH.""CallStart"", CH.""CallEnd"",CH.""LastName"", CH.""Type""
                            From ""CallHistory"" CH
                            Join ""Account"" Acc On CH.""CreatedBy"" = Acc.""AccountId""
                            order by CH.""Id"" desc"; }

            var response = await this.unitOfWork.Current.QueryAsync<Call_HistoryModel>(query);
            return response;
        }

        public async Task<IEnumerable<Call_HistoryModel>> FindByMobileNum(Call_HistoryModel model)
        {
            var query = $@"Select CH.""Id"",CH.""CallDuration"",Acc.""FullName"",CH.""MobileNumber"", CH.""FirstName"", CH.""CreatedDate"", CH.""Comments"", 
                            CH.""CallStart"", CH.""CallEnd"",CH.""LastName"", CH.""Type""
                            From ""CallHistory"" CH Join ""Account"" Acc On CH.""CreatedBy"" = Acc.""AccountId"" WHERE CH.""MobileNumber""= '{model.MobileNumber}' order by CH.""Id"" desc ";
            var response = await this.unitOfWork.Current.QueryAsync<Call_HistoryModel>(query);
            return response;


        }

        public async Task<int> UpdateAsync(CallHistory model)
        {
            //if (model.Id == 0)
            //{
            //    string query1 = "select \"Id\" from \"CallHistory\" ORDER BY \"Id\" DESC LIMIT 1";
            //    var Id = this.unitOfWork.Current.QueryAsync<int>(query1).Result.SingleOrDefault();
            //    model.Id = Id;

            //}
            var problems = await this.unitOfWork.CallHistorys.FindAsync(m => m.Id == model.Id);
            if (model.MobileNumber != null) { problems.MobileNumber = model.MobileNumber; }
            if (model.FirstName != null) { problems.FirstName = model.FirstName; }
            if (model.LastName != null) { problems.LastName = model.LastName; }
            if (model.CallStart != null) { problems.CallStart = model.CallStart; }
            if (model.CallEnd != null) { problems.CallEnd = model.CallEnd; }
            if (model.CallDuration != null) { problems.CallDuration = model.CallDuration; }
            problems.ModifiedBy = model.ModifiedBy;
            problems.ModifiedDate = DateTime.Now;
            return await this.unitOfWork.CallHistorys.UpdateAsync(problems);
        }
    }
}
