﻿namespace Hims.Infrastructure.Services
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Threading.Tasks;
    using Dapper;
    using Domain.Entities;
    using Domain.Repositories.UnitOfWork;
    using Domain.Services;
    using Hims.Shared.Library;
    using Shared.EntityModels;
    using Shared.UserModels.ProviderSchedule;

    /// <inheritdoc />
    public class ProviderScheduleService : IProviderScheduleService
    {
        /// <summary>
        /// The unit of work.
        /// </summary>
        private readonly IUnitOfWork unitOfWork;

        /// <inheritdoc cref="IProviderScheduleService" />
        public ProviderScheduleService(IUnitOfWork unitOfWork) => this.unitOfWork = unitOfWork;

        /// <inheritdoc />
        public Task<IEnumerable<FilterViewModel>> FetchAsync(FilterModel model)
        {
            var query = "";

            if (model.ProviderId != null)
            {
                string[] ProviderIdsArray = model.ProviderId.Split(',');
                string[] SpecializationIdsArray = model.SpecializationId.Split(',');
                if (ProviderIdsArray != null)
                {
                    int pLen = ProviderIdsArray.Length;
                    for (int p = 0; p < pLen; p++)
                    {
                        var where = " WHERE 1 = 1 ";

                        where += $@"  and  p.""LocationId"" = {model.LocationId} and p.""ProviderId"" in ({ProviderIdsArray[p]}) and s.""SpecializationId"" in ({SpecializationIdsArray[p]})";

                        query += $@"union Select p.""ProviderLocationId"",p.""ProviderId"",Pr.""DepartmentId"",Dt.""DepartmentName"",Pr.""FullName"" ""ProviderName"", string_to_array(p.""AvailableDays"", ',')::int[] as ""AvailableDays"", 
                                           p.""Duration"",
                                           p.""Availability"", s.""SpecializationId"", s.""SpecializationName""
                                         from ""ProviderLocation"" p
                                         join ""Provider"" Pr on Pr.""ProviderId"" = p.""ProviderId""
                                        join ""Specialization"" s on s.""SpecializationId"" = any (Pr.""Specializations"")
                                            join ""Department"" Dt on Dt.""DepartmentId"" = Pr.""DepartmentId""   
                                         { where}  and Pr.""Active"" = true and s.""Active"" = true    " + Environment.NewLine;
                    }

                }
            }
            if (!string.IsNullOrEmpty(query))
            {
                query = query.Substring(6);
            }
            return this.unitOfWork.Current.QueryAsync<FilterViewModel>(query);
        }

        /// <inheritdoc />
        public Task<IEnumerable<EventViewModel>> FetchEventAsync(FilterModel model)
        {
            var where = " WHERE 1 = 1 ";

            var breaks = " WHERE 1 = 1 ";

            var leaves = " where 1 = 1";

            where += $@"  and  Ap.""ProviderId"" in ({model.ProviderId}) and s.""SpecializationId"" in ({model.SpecializationId})";

            if ((bool)(model.AppointmentStatus == false))
            {
                where += $@" and Ap.""Status"" != 'C'";
            }

            if (!string.IsNullOrEmpty(model.AppointmentDate) && string.IsNullOrEmpty(model.AppointmentEndDate))
            {
                where += $@" and Ap.""AppointmentDate"" = '{model.AppointmentDate}'";
            }

            if (!string.IsNullOrEmpty(model.AppointmentDate) && !string.IsNullOrEmpty(model.AppointmentEndDate))
            {
                where += $@" AND Ap.""AppointmentDate""::DATE >= '{model.AppointmentDate}'::DATE";
                where += $@" AND Ap.""AppointmentDate""::DATE <= '{model.AppointmentEndDate}'::DATE";

                leaves += $@" AND PL.""LeaveDate""::DATE = '{model.AppointmentDate}'::DATE ";
                leaves += $@" AND  PL.""ProviderId"" in ({model.ProviderId}) ";

                breaks += $@" and A.""BreakDates""::DATE >= '{model.AppointmentDate}'::DATE ";
                breaks += $@" AND A.""BreakDates""::DATE <= '{model.AppointmentDate}'::DATE ";
                breaks += $@" AND  A.""ProviderId"" in ({model.ProviderId}) and A.""SpecializationId"" in ({model.SpecializationId})";
            }

            if (model.LocationId != null || model.LocationId != 0)
            {
                where += $@" and Ap.""LocationId"" = {model.LocationId}";
                leaves += $@" and PL.""LocationId"" = {model.LocationId}";
                breaks += $@" and A.""LocationId"" = {model.LocationId}";
                
            }

            if (model.ConsultationTypeId != null || model.ConsultationTypeId != 0)
            {
                where += $@" and Ap.""ConsultationTypeId"" = {model.ConsultationTypeId}";
                breaks += $@" and A.""ConsultationTypeId"" = {model.ConsultationTypeId}";
            }

            var slotDuration = model.SlotDuration;

            //   var query = $@"select Ap.""IsSalucroAppointment"",Ap.""AppointmentId"",Ap.""ProviderId"",Ap.""SpecializationId"",Ap.""LocationId"",Ap.""PatientId"",Ap.""DepartmentId"",Pa.""FullName"" as ""PatientName"",Ap.""CheckedIn"",Ap.""ProviderLocationId"",Ap.""VisitTypeId"",Ap.""PaymentNumber"",
            //                           Ap.""ProviderAvailabilityId"",Ap.""ConsultationTypeId"",Ap.""PaymentStatus"",
            //                           Ap.""CheckedOut"",  CONCAT(""AppointmentDate"", 'T', ""AppointmentTime"") as ""AppointmentStartDateTime"",Ad.""VisitorName""  as ""AppointmentTypeName"", TO_CHAR(Ap.""AppointmentDate"", 'MM/DD/YYYY') || ' ' || TO_CHAR(Ap.""AppointmentTime"", 'hh12:mi AM') as ""AppointmentDateTime"" ,
            //                           --CONCAT(""AppointmentDate"", 'T', ""AppointmentTime"" + '{slotDuration} minute'::INTERVAL) as ""AppointmentEndDateTime""
            //                           CONCAT(""AppointmentDate"", 'T', ""AppointmentEndTime"") as ""AppointmentEndDateTime""
            //                           , Ap.""TokenNumber"", Ap.""Status"", Ap.""EncounterType"",
            //                 Pa.""Age"" as ""PatientAge"",Pa.""Gender""::text,Pa.""FatherOrHusband"",Pa.""UMRNo"",Pa.""Mobile"",Pa.""AadharNo"",Pa.""ReferredByName"",Ap.""AppointmentNo"",
            //               Ap.""AppointmentDate"",Ap.""ChargeType"", Ap.""Discount"",Ap.""Total"",Ap.""Amount"",Po.""FullName"" as ""DoctorName"",
            //               Dp.""DepartmentName"",Pa.""StreetAddress"",Pa.""AddressLine2"",Pa.""City"",Pa.""State"",Pa.""Zipcode"",Ce.""ChargeName"",Pe.""PayTypeName"", Pa.""IdProofId"",Pa.""IdProofValue"", Ip.""IdProofName"", Ad.""RowColor""

            //                           from ""Appointment"" Ap
            //                           join ""Provider"" Po on Po.""ProviderId""=Ap.""ProviderId""
            //                           join ""Specialization"" s on s.""SpecializationId"" = any(Po.""Specializations"")
            //                           join ""Department"" Dp on Dp.""DepartmentId""=Po.""DepartmentId""
            //                     join ""Patient"" Pa on Pa.""PatientId"" = Ap.""PatientId""
            //                           left join ""IdProof"" Ip on Ip.""IdProofId"" = Pa.""IdProofId""
            //                           join ""ChargeTypes"" Ce on Ce.""ChargeTypesId"" = Ap.""ChargeTypesId""
            //                           join ""VisitType"" Ad on Ad.""VisitTypeId""= Ap.""VisitTypeId""
            //                           left join ""PayType"" Pe on Pe.""PayTypeId""=Ap.""PayTypeId""


            //{ where} and Ap.""AppointmentTime"" is not null and Ap.""AppointmentEndTime"" is not null ";



            var query = $@" SELECT Ap.""IsSalucroAppointment"",Ap.""Active"",Ap.""AppointmentId"",Ap.""ProviderId"",Ap.""SpecializationId"",Ap.""LocationId"",Ap.""PatientId"",Ap.""DepartmentId"",Pa.""FullName"" as ""PatientName"",Ap.""CheckedIn""::text,Ap.""ProviderLocationId"",Ap.""VisitTypeId"",Ap.""PaymentNumber"",
                                    Ap.""ProviderAvailabilityId"",Ap.""ConsultationTypeId"",Ap.""PaymentStatus"",Ap.""PaymentType"",
                                    Ap.""CheckedOut""::text,  CONCAT(""AppointmentDate"", 'T', ""AppointmentTime"") as ""AppointmentStartDateTime"",Ad.""VisitorName""  as ""AppointmentTypeName"", TO_CHAR(Ap.""AppointmentDate"", 'MM/DD/YYYY') || ' ' || TO_CHAR(Ap.""AppointmentTime"", 'hh12:mi AM') as ""AppointmentDateTime"" ,
                                    --CONCAT(""AppointmentDate"", 'T', ""AppointmentTime"" + ' {slotDuration} minute'::INTERVAL) as ""AppointmentEndDateTime""
                                    CONCAT(""AppointmentDate"", 'T', ""AppointmentEndTime"") as ""AppointmentEndDateTime""
                                    , Ap.""TokenNumber"", Ap.""Status"", Ap.""EncounterType""::text,
                          Pa.""Age"" as ""PatientAge"",Pa.""Gender""::text,Pa.""FatherOrHusband"",Pa.""UMRNo"",Pa.""Mobile"",Pa.""AadharNo"",Pa.""ReferredByName"",Ap.""AppointmentNo"",
                        Ap.""AppointmentDate"",Ap.""ChargeType"", Ap.""Discount"",Ap.""Total"",Ap.""Amount"",Po.""FullName"" as ""DoctorName"",
                        Dp.""DepartmentName"",Pa.""StreetAddress"",Pa.""AddressLine2"",Pa.""City"",Pa.""State"",Pa.""Zipcode"",Ce.""ChargeName"",Pe.""PayTypeName"", Pa.""IdProofId"",Pa.""IdProofValue"", Ip.""IdProofName"", Ad.""RowColor"", 0 as  ""ProviderBreakId"", 'null' as  ""StartDate"", 'null' as  ""EndDate"", 'null' as  ""BreakDay"", 'null' as ""StartTime"", 'null' as ""EndTime"", 'null' as ""BreakDate"", 'null' as""BreakType"", 'null' as ""BreakBlock"", 'null' as ""BreakDates""
                        ,'A' as ""AvailabilityType"",
		                        C.""FullName"" as ""CreatedByName"", CR.""RoleName"" as ""CreatedByRole"",M.""FullName"" as ""ModifiedByName"", MR.""RoleName"" as ""ModifiedByRole""

                                    from ""Appointment"" Ap
                                    join ""Provider"" Po on Po.""ProviderId""=Ap.""ProviderId""
                                    join ""Specialization"" s on s.""SpecializationId"" = any(Po.""Specializations"")
                                    join ""Department"" Dp on Dp.""DepartmentId""=Po.""DepartmentId""
		                            join ""Patient"" Pa on Pa.""PatientId"" = Ap.""PatientId""
                                    left join ""IdProof"" Ip on Ip.""IdProofId"" = Pa.""IdProofId""
                                    join ""ChargeTypes"" Ce on Ce.""ChargeTypesId"" = Ap.""ChargeTypesId""
                                    join ""VisitType"" Ad on Ad.""VisitTypeId""= Ap.""VisitTypeId""
                                    left join ""PayType"" Pe on Pe.""PayTypeId""=Ap.""PayTypeId""
                                     join ""Account"" C on C.""AccountId"" = Ap.""CreatedBy""
                             join ""Role"" CR on CR.""RoleId"" = C.""RoleId""
                             left join ""Account"" M on M.""AccountId"" = Ap.""ModifiedBy""
                             left join ""Role"" MR on MR.""RoleId"" = M.""RoleId""
{ where} and Ap.""AppointmentTime"" is not null and Ap.""AppointmentEndTime"" is not null 

UNION ALL  SELECT distinct false as ""IsSalucroAppointment"",false as ""Active"",0 as ""AppointmentId"",PL.""ProviderId"",s.""SpecializationId"",PL.""LocationId"", 0 as ""PatientId"",0 as ""DepartmentId"",'null' as ""PatientName"", 'null' as  ""CheckedIn"",0 as ""ProviderLocationId"", 0 as ""VisitTypeId"",'null' ""PaymentNumber"",
                                   0 as ""ProviderAvailabilityId"",0 as ""ConsultationTypeId"",false as ""PaymentStatus"",null as ""PaymentType"",  null as ""CheckedOut"",
						  CONCAT(UNNEST(string_to_array(PL.""LeaveDate""::text, ',')), 'T', PL.""ProviderLeaveStartTime""::text) as ""AppointmentStartDateTime""
						
						 --,  CONCAT(""AppointmentDate"", 'T', ""AppointmentTime"") as ""AppointmentStartDateTime""
						 ,'null' as ""AppointmentTypeName"" 
						 ,'null' as ""AppointmentDateTime""
                        --, CONCAT(""AppointmentDate"", 'T', ""AppointmentEndTime"") as ""AppointmentEndDateTime""
						 ,CONCAT(UNNEST(string_to_array(PL.""LeaveDate""::text, ',')), 'T', PL.""ProviderLeaveEndTime""::text ) as ""AppointmentEndDateTime""
                        , 0 as ""TokenNumber"", 'U' as ""Status"", null as ""EncounterType"",
                         0 as ""PatientAge"",'null' as ""Gender"",'null' as ""FatherOrHusband"",'null' as ""UMRNo"",'null' as ""Mobile"",'null' ""AadharNo"",'null' ""ReferredByName"",'null' ""AppointmentNo"",
                        CURRENT_DATE as ""AppointmentDate"",'null' as ""ChargeType"",0 as ""Discount"",0  as ""Total"",0 as ""Amount"",'null' as ""DoctorName"",
                       'null' as ""DepartmentName"",'null' as ""StreetAddress"",'null' as ""AddressLine2"",'null' as ""City"",'null' as ""State"",'null' as ""Zipcode"",'null' as ""ChargeName"",'null' as ""PayTypeName"",0 as ""IdProofId"",'null' as ""IdProofValue"", 'null' as ""IdProofName"", 'null' as ""RowColor"",
						
						PL.""ProviderLeaveId"", 'null' as  ""StartDate"", 'null' as  ""EndDate"", 'null' as  ""BreakDay"", PL.""ProviderLeaveStartTime""::text, PL.""ProviderLeaveEndTime""::text, PL.""LeaveDate""::text,  PL.""Reason"" as ""BreakType"", 'Permanent' as ""BreakBlock"", 'null' as ""BreakDates""
                        ,'L' as ""AvailabilityType"",
		                        C.""FullName"" as ""CreatedByName"", CR.""RoleName"" as ""CreatedByRole"",M.""FullName"" as ""ModifiedByName"", MR.""RoleName"" as ""ModifiedByRole""
                                    from ""ProviderLeave"" PL 
                                    join ""Provider"" Po on Po.""ProviderId""= PL.""ProviderId""
                                    join ""Specialization"" s on s.""SpecializationId"" = any(Po.""Specializations"")
                                     join ""Account"" C on C.""AccountId"" = PL.""CreatedBy""
                             join ""Role"" CR on CR.""RoleId"" = C.""RoleId""
                             left join ""Account"" M on M.""AccountId"" = PL.""ModifiedBy""
                             left join ""Role"" MR on MR.""RoleId"" = M.""RoleId""

{leaves}

UNION ALL SELECT * from (  SELECT distinct false as ""IsSalucroAppointment"",false as ""Active"",0 as ""AppointmentId"",PRB.""ProviderId"",PRB.""SpecializationId"",PRB.""LocationId"", 0 as ""PatientId"",0 as ""DepartmentId"",'null' as ""PatientName"", 'null' as  ""CheckedIn"",0 as ""ProviderLocationId"", 0 as ""VisitTypeId"",'null' ""PaymentNumber"",
                                   0 as ""ProviderAvailabilityId"",PRB.""ConsultationTypeId"",false as ""PaymentStatus"", null as ""PaymentType"", null as ""CheckedOut"",
						  CONCAT(UNNEST(string_to_array(PRB.""BreakDate"", ',')), 'T', PRB.""StartTime"") as ""AppointmentStartDateTime""
						
						 --,  CONCAT(""AppointmentDate"", 'T', ""AppointmentTime"") as ""AppointmentStartDateTime""
						 ,'null' as ""AppointmentTypeName"" 
						 ,'null' as ""AppointmentDateTime""
                        --, CONCAT(""AppointmentDate"", 'T', ""AppointmentEndTime"") as ""AppointmentEndDateTime""
						 ,CONCAT(UNNEST(string_to_array(PRB.""BreakDate"", ',')), 'T', PRB.""EndTime"" ) as ""AppointmentEndDateTime""
                        , 0 as ""TokenNumber"", 'U' as ""Status"", null as ""EncounterType"",
                         0 as ""PatientAge"",'null' as ""Gender"",'null' as ""FatherOrHusband"",'null' as ""UMRNo"",'null' as ""Mobile"",'null' ""AadharNo"",'null' ""ReferredByName"",'null' ""AppointmentNo"",
                        CURRENT_DATE as ""AppointmentDate"",'null' as ""ChargeType"",0 as ""Discount"",0  as ""Total"",0 as ""Amount"",'null' as ""DoctorName"",
                       'null' as ""DepartmentName"",'null' as ""StreetAddress"",'null' as ""AddressLine2"",'null' as ""City"",'null' as ""State"",'null' as ""Zipcode"",'null' as ""ChargeName"",'null' as ""PayTypeName"",0 as ""IdProofId"",'null' as ""IdProofValue"", 'null' as ""IdProofName"", 'null' as ""RowColor"",
						
						PRB.""ProviderBreakId"", PRB. ""StartDate"",PRB. ""EndDate"",PRB. ""BreakDay"", PRB.""StartTime"", PRB.""EndTime"", PRB.""BreakDate"", PRB.""BreakType"", PRB.""BreakBlock"",  UNNEST(string_to_array(PRB.""BreakDate"", ',')) as ""BreakDates""
                        ,'B' as ""AvailabilityType"",
		                        C.""FullName"" as ""CreatedByName"", CR.""RoleName"" as ""CreatedByRole"",M.""FullName"" as ""ModifiedByName"", MR.""RoleName"" as ""ModifiedByRole""
                                    from ""ProviderBreak"" PRB 
                                    join ""Provider"" Po on Po.""ProviderId""= PRB.""ProviderId""
                                    join ""Specialization"" s on s.""SpecializationId"" = any(Po.""Specializations"")
                                     join ""Account"" C on C.""AccountId"" = PRB.""CreatedBy""
                             join ""Role"" CR on CR.""RoleId"" = C.""RoleId""
                             left join ""Account"" M on M.""AccountId"" = PRB.""ModifiedBy""
                             left join ""Role"" MR on MR.""RoleId"" = M.""RoleId""
                                    ) A
		  {breaks}  ";

            return this.unitOfWork.Current.QueryAsync<EventViewModel>(query);
        }


        public Task<IEnumerable<EventViewModel>> FetchFilterEvent(FilterModel model)
        {

            var where = " WHERE 1 = 1 ";

            // if (!string.IsNullOrEmpty(model.FromDate))
            if (!string.IsNullOrEmpty(model.Filter[0].FromDate) && !string.IsNullOrEmpty(model.Filter[0].ToDate))
            {
                where += $@" AND Ap.""AppointmentDate""::DATE >= '{model.Filter[0].FromDate}'::DATE";
                where += $@" AND Ap.""AppointmentDate""::DATE <= '{model.Filter[0].ToDate}'::DATE";
            }

            if (!string.IsNullOrEmpty(model.Filter[0].FromDate) && string.IsNullOrEmpty(model.Filter[0].ToDate))
            {
                where += $@" AND Ap.""AppointmentDate""::DATE = '%{model.Filter[0].FromDate}%'";
            }
            if (model.Filter[0].ProviderId == null)
            {
                where += $@"  and  Ap.""ProviderId"" in ({model.ProviderId}) and Ap.""SpecializationId"" in ({model.SpecializationId})";
            }
            else
            {
                where += $@" AND Ap.""ProviderId"" = {model.Filter[0].ProviderId}";
            }

            if (model.Filter[0].PatientId != null)
            {
                where += $@" AND Ap.""PatientId"" = {model.Filter[0].PatientId}";
            }

            if (model.Filter[0].LocationId != null || model.Filter[0].LocationId != 0)
            {
                where += $@" and Ap.""LocationId"" = {model.LocationId}";
            }
            else
            {
                where += $@" and Ap.""LocationId"" = {model.Filter[0].LocationId}";
            }

            if (model.Filter[0].ConsultationTypeId != null || model.Filter[0].ConsultationTypeId != 0)
            {
                where += $@" and Ap.""ConsultationTypeId"" = {model.ConsultationTypeId}";
            }
            else
            {
                where += $@" and Ap.""ConsultationTypeId"" = {model.Filter[0].ConsultationTypeId}";
            }


            var query = $@"select Ap.""IsSalucroAppointment"",Ap.""AppointmentId"",Ap.""SpecializationId"",Ap.""LocationId"",Ap.""ProviderId"",Ap.""PatientId"",Ap.""DepartmentId"",Pa.""FullName"" as ""PatientName"",Pa.""UMRNo"",Pa.""Mobile"",
                            Ap.""TokenNumber"",Po.""FullName"" as ""DoctorName"",Ap.""AppointmentDate""::text as ""Date"",Ap.""AppointmentTime""::text,
                            Ap.""ProviderAvailabilityId"",Ap.""ConsultationTypeId"", CONCAT(Ap.""AppointmentDate"", 'T', Ap.""AppointmentTime"") as ""AppointmentStartDateTime""
                            ,CONCAT(""AppointmentDate"", 'T', ""AppointmentEndTime"") as ""AppointmentEndDateTime"", Ap.""ChargeTypesId"", Ap.""VisitTypeId""
                                    from ""Appointment"" Ap 
		                           join ""Patient"" Pa on Pa.""PatientId"" = Ap.""PatientId""
                                    join ""Provider"" Po on Po.""ProviderId""=Ap.""ProviderId""
                                   { where} and Ap.""AppointmentTime"" is not null and Ap.""Status"" != 'C' ";
            return this.unitOfWork.Current.QueryAsync<EventViewModel>(query);

        }

        /// <inheritdoc />
        public Task<IEnumerable<FilterViewModel>> FetchAvailabilityScheduleAsync(FilterModel model)
        {
            var query = "";

            if (model.ProviderId != null)
            {
                string[] ProviderIdsArray = model.ProviderId.Split(',');
                string[] SpecializationIdsArray = model.SpecializationId.Split(',');
                if (ProviderIdsArray != null)
                {
                    int pLen = ProviderIdsArray.Length;
                    for (int p = 0; p < pLen; p++)
                    {
                        var where = " WHERE 1 = 1 ";

                        if (model.CalendarView == "resourceTimeGridDay")
                        {
                            where += $@"  and  p.""LocationId"" = {model.LocationId} and p.""ProviderId"" in ({ProviderIdsArray[p]}) and p.""SpecializationId"" in ({SpecializationIdsArray[p]})  and p.""ConsultationTypeId"" in ({model.ConsultationTypeId})  
									and p.""StartDate""::DATE <= '{model.StartDate}'::DATE
                                     and p.""EndDate""::Date >= '{model.EndDate}'::Date";
                        }
                        else
                        {
                            where += $@"  and  p.""LocationId"" = {model.LocationId} and p.""ProviderId"" in ({ProviderIdsArray[p]}) and p.""SpecializationId"" in ({SpecializationIdsArray[p]})  and p.""ConsultationTypeId"" in ({model.ConsultationTypeId})  
									--and p.""StartDate""::DATE >= '{model.StartDate}'::DATE
                                     --and p.""EndDate""::Date <= '{model.EndDate}'::Date
                                    and (
										
									('{model.StartDate}'::Date <=	p.""StartDate""::Date or 
									 p.""StartDate""::Date >=  '{model.EndDate}'::DATE )
										or
									('{model.StartDate}'::Date <=	p.""EndDate""::Date
										or
										p.""EndDate""::Date >=    '{model.EndDate}'::DATE
									)
									)";
                        }

                        query += $@"union Select p.""ProviderAvailabilityId"",p.""ProviderId"",Pr.""DepartmentId"",Dt.""DepartmentName"",Pr.""FullName"" ""ProviderName""
								,p.""LocationId"", p.""ConsultationTypeId"", p.""StartDate"", p.""EndDate""
								,p.""StartTime"",p.""EndTime"",p.""AvailableDay"", p.""AvailableDate""
								,p.""SpecializationId""
                                --,p.""FreeFollowUpDays"", p.""FreeFollowUpDaysLimit""
								,S.""SpecializationName""
								--,PAV.""VisitTypeId"", PAV.""Duration"" as ""AvailabilityDuration""
                                        from ""ProviderAvailability"" p
                                join ""Provider"" Pr on Pr.""ProviderId"" = p.""ProviderId""
                                join ""Department"" Dt on Dt.""DepartmentId"" = Pr.""DepartmentId""   
								--join ""ProviderAvailabilitySlot"" PAS on PAS.""ProviderAvailabilityId"" = p.""ProviderAvailabilityId""
								--join ""ProviderAvailabilityVisitType"" PAV on PAV.""ProviderAvailabilityId"" = p.""ProviderAvailabilityId""
                                join ""Specialization"" s on s.""SpecializationId"" = p.""SpecializationId"" 
                                    { where}  and Pr.""Active"" = true and s.""Active"" = true    " + Environment.NewLine;
                    }

                }
            }
            if (!string.IsNullOrEmpty(query))
            {
                query = query.Substring(6);
            }
            return this.unitOfWork.Current.QueryAsync<FilterViewModel>(query);
        }

    }

}