﻿using Hims.Domain.Entities.Enums;

namespace Hims.Infrastructure.Services
{
    using System;
    using System.Collections.Generic;
    using System.Threading.Tasks;

    using Dapper;

    using Domain.Configurations;
    using Domain.Entities;
    using Domain.Repositories.UnitOfWork;
    using Domain.Services;
    using Newtonsoft.Json;
    using Shared.DataFilters;
    using Shared.EntityModels;
    using Shared.Library.Enums;
    using Shared.UserModels.Filters;

    /// <inheritdoc />
    public class SmsLogservice : ISmsLogService
    {
        /// <summary>
        /// The unit of work.
        /// </summary>
        private readonly IUnitOfWork unitOfWork;


        /// <inheritdoc cref="IAppointmentService" />
        public SmsLogservice(IUnitOfWork unitOfWork)
        {
            this.unitOfWork = unitOfWork;
        }

        /// <inheritdoc />
        public async Task<int> Insert(SMSLogModel model)
        {
            try
            {
                var smsLog = new SMSLog
                {
                    Response = model.Response,
                    SendedDate = model.SendedDate,
                    ReceiverNumber = model.ReceiverNumber
                };
                var response = await this.unitOfWork.SMSLogs.InsertAsync(smsLog);
                return response;

            }
            catch
            {
                return 0;
            }
        }
    }
}