﻿namespace Hims.Shared.EntityModels
{
    using System;

    /// <summary>
    /// The account session.
    /// </summary>
    public class AccountSessionModel
    {
        /// <summary>
        /// Gets or sets the account session id.
        /// </summary>
        public int AccountSessionId { get; set; }

        /// <summary>
        /// Gets or sets the account id.
        /// </summary>
        public int AccountId { get; set; }

        /// <summary>
        /// Gets or sets the device ID.
        /// </summary>
        public string DeviceId { get; set; }

        /// <summary>
        /// Gets or sets the device key.
        /// </summary>
        public string DeviceToken { get; set; }

        /// <summary>
        /// Gets or sets the device type.
        /// </summary>
        public short DeviceType { get; set; }

        /// <summary>
        /// Gets or sets the description.
        /// </summary>
        public string Description { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }
    }
}