﻿#nullable enable
namespace Hims.Shared.EntityModels
{
    using System;

    /// <summary>
    /// The appointment exception log.
    /// </summary>
    public class AppointmentExceptionLogModel
    {
        /// <summary>
        /// Gets or sets the appointment exception log id.
        /// </summary>
        public int AppointmentExceptionLogId { get; set; }

        /// <summary>
        /// Gets or sets the appointment log id.
        /// </summary>
        public int? AppointmentLogId { get; set; }

        /// <summary>
        /// Gets or sets the appointment id.
        /// </summary>
        public int? AppointmentId { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether payment status.
        /// </summary>
        public bool PaymentStatus { get; set; }

        /// <summary>
        /// Gets or sets the exception date.
        /// </summary>
        public DateTime ExceptionDate { get; set; }

        /// <summary>
        /// Gets or sets the exception message.
        /// </summary>
        public string ExceptionMessage { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the stack trace.
        /// </summary>
        public string? StackTrace { get; set; }

        /// <summary>
        /// Gets or sets the payment transaction id.
        /// </summary>
        public string? PaymentTransactionId { get; set; }
    }
}
