﻿#nullable enable
namespace Hims.Shared.EntityModels
{
    using System;

    /// <summary>
    /// The appointment log.
    /// </summary>
    public class AppointmentLogModel
    {
        /// <summary>
        /// Gets or sets the appointment log id.
        /// </summary>
        public int AppointmentLogId { get; set; }

        /// <summary>
        /// Gets or sets the provider location id.
        /// </summary>
        public int? ProviderLocationId { get; set; }

        /// <summary>
        /// Gets or sets the provider location id.
        /// </summary>
        public int ProviderAvailabilityId { get; set; }

        /// <summary>
        /// Gets or sets the provider location id.
        /// </summary>
        public int ConsultationTypeId { get; set; }

        /// <summary>
        /// Gets or sets the provider id.
        /// </summary>
        public int ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the provider name.
        /// </summary>
        public string? ProviderName { get; set; }

        /// <summary>
        /// Gets or sets the provider thumbnail url.
        /// </summary>
        public string? ProviderThumbnailUrl { get; set; }

        /// <summary>
        /// Gets or sets the practice name.
        /// </summary>
        public string? PracticeName { get; set; }

        /// <summary>
        /// Gets or sets the provider location.
        /// </summary>
        public string? ProviderLocation { get; set; }

        /// <summary>
        /// Gets or sets the currency symbol.
        /// </summary>
        public char CurrencySymbol { get; set; }

        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        public int PatientId { get; set; }

        /// <summary>
        /// Gets or sets the patient first name.
        /// </summary>
        public string? PatientFirstName { get; set; }

        /// <summary>
        /// Gets or sets the patient last name.
        /// </summary>
        public string? PatientLastName { get; set; }

        /// <summary>
        /// Gets or sets the patient email.
        /// </summary>
        public string? PatientEmail { get; set; }

        /// <summary>
        /// Gets or sets the patient mobile.
        /// </summary>
        public string? PatientMobile { get; set; }

        /// <summary>
        /// Gets or sets the patient country name.
        /// </summary>
        public string? PatientCountryName { get; set; }

        /// <summary>
        /// Gets or sets the visit type.
        /// </summary>
        public char? VisitType { get; set; }

        /// <summary>
        /// Gets or sets the patient type.
        /// </summary>
        public char? PatientType { get; set; }

        /// <summary>
        /// Gets or sets the charge type.
        /// </summary>
        public char? ChargeType { get; set; }

        /// <summary>
        /// Gets or sets the appointment date.
        /// </summary>
        public DateTime AppointmentDate { get; set; }

        /// <summary>
        /// Gets or sets the appointment time.
        /// </summary>
        public TimeSpan AppointmentTime { get; set; }

        /// <summary>
        /// Gets or sets the appointment end time.
        /// </summary>
        public TimeSpan AppointmentEndTime { get; set; }

        /// <summary>
        /// Gets or sets the appointment notes.
        /// </summary>
        public string? AppointmentNotes { get; set; }

        /// <summary>
        /// Gets or sets the coupon id.
        /// </summary>
        public int? CouponId { get; set; }

        /// <summary>
        /// Gets or sets the amount.
        /// </summary>
        public decimal Amount { get; set; }

        /// <summary>
        /// Gets or sets the discount.
        /// </summary>
        public decimal Discount { get; set; }

        /// <summary>
        /// Gets or sets the app charges.
        /// </summary>
        public decimal AppCharges { get; set; }

        /// <summary>
        /// Gets or sets the wallet amount.
        /// </summary>
        public decimal? WalletAmount { get; set; }

        /// <summary>
        /// Gets or sets the total.
        /// </summary>
        public decimal Total { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the patient family id.
        /// </summary>
        public int? PatientFamilyId { get; set; }

        /// <summary>
        /// Gets or sets the percentage.
        /// </summary>
        public double? Percentage { get; set; }

        /// <summary>
        /// Gets or sets the department id.
        /// </summary>
        public int? DepartmentId { get; set; }

        /// <summary>
        ///  Gets or sets payment type.
        /// </summary>
        public string? PaymentType { get; set; }

        /// <summary>
        ///  Gets or sets follow up for AppointmentId.
        /// </summary>
        public int? FollowUpForAppointmentId { get; set; }

        /// <summary>
        ///  Gets or sets follow up for admission id.
        /// </summary>
        public int? FollowUpForAdmissionId { get; set; }

        /// <summary>
        /// Gets or sets the follow up days.
        /// </summary>
        public short? FollowUpDays { get; set; }

        /// <summary>
        /// Gets or sets the location identifier.
        /// </summary>
        /// <value>
        /// The location identifier.
        /// </value>
        public int LocationId { get; set; }

        /// <summary>
        /// Gets or sets the appointment identifier.
        /// </summary>
        /// <value>
        /// The appointment identifier.
        /// </value>
        public int? AppointmentTypeId { get; set; }

        /// <summary>
        /// Gets or sets the visitype identifier.
        /// </summary>
        /// <value>
        /// The visitype identifier.
        /// </value>
        public int? VisitTypeId { get; set; }

        /// <summary>
        /// Gets or sets the chargetype identifier.
        /// </summary>
        /// <value>
        /// The chargetype identifier.
        /// </value>
        public int? ChargeTypesId { get; set; }

        /// <summary>
        /// Gets or sets the appointment identifier.
        /// </summary>
        /// <value>
        /// The appointment identifier.
        /// </value>
        public int PayTypeId { get; set; }

        /// <summary>
        /// Gets or sets the token number.
        /// </summary>
        /// <value>
        /// The token number.
        /// </value>
        public int TokenNumber { get; set; }

        /// <summary>
        /// Gets or sets the SpecializationId.
        /// </summary>
        /// <value>
        /// The SpecializationId.
        /// </value>
        public int? SpecializationId { get; set; }

        /// <summary>
        /// Gets or sets the registration charges. 
        /// this value is used to add in Patient table (while inserting new patient either identify or unidentify patient.)
        /// </summary>
        public decimal? PatientRegistrationCharges { get; set; }
    }
}
