﻿
using System;
using System.Collections.Generic;
using System.Text;

namespace Hims.Shared.EntityModels
{
    public class DietItemsModel
    {
        /// <summary>
        /// Gets or sets the diet item id.
        /// </summary>
       
        public int DietItemsId { get; set; }

        /// <summary>
        /// Gets or sets the name.
        /// </summary>
        public string DietItemsName { get; set; }


        /// <summary>
        /// Gets or sets the active or inactive.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the login role identifier.
        /// </summary>
        /// <value>
        /// The login role identifier.
        /// </value>
        public short? LoginRoleId { get; set; }

        /// <summary>
        /// Gets or sets the name of the created by.
        /// </summary>
        /// <value>
        /// The name of the created by.
        /// </value>
        public string? CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the name of the modified name.
        /// </summary>
        /// <value>
        /// The name of the modified by.
        /// </value>
        public string? ModifiedByName { get; set; }


        public int MeasureId { get; set; }

        public string MeasureName { get; set; }
    }
}
