﻿namespace Hims.Shared.EntityModels
{
    using System;
    using System.Collections.Generic;
    using System.Text;

    /// <summary>
    /// The product email model.
    /// </summary>
    public class ProductEmailModel
    {
        /// <summary>
        /// Gets or sets the inventory product id.
        /// </summary>
        public int InventoryProductId { get; set; }

        /// <summary>
        /// Gets or sets the company id.
        /// </summary>
        public int CompanyId { get; set; }

        /// <summary>
        /// Gets or sets the category id.
        /// </summary>
        public int CategoryId { get; set; }

        /// <summary>
        /// Gets or sets the supplier id.
        /// </summary>
        public int? SupplierId { get; set; }

        /// <summary>
        /// Gets or sets the tax id.
        /// </summary>
        public int TaxId { get; set; }

        /// <summary>
        /// Gets or sets the max quantity.
        /// </summary>
        public int? MaxQuantity { get; set; }

        /// <summary>
        /// Gets or sets the min quantity.
        /// </summary>
        public int? MinQuantity { get; set; }

        /// <summary>
        /// Gets or sets the reorder level quantity.
        /// </summary>
        public int ReorderLevelQuantity { get; set; }

        /// <summary>
        /// Gets or sets the rack id.
        /// </summary>
        public int RackId { get; set; }

        /// <summary>
        /// Gets or sets the purchase unit.
        /// </summary>
        public int PurchaseUnit { get; set; }

        /// <summary>
        /// Gets or sets the purchase unit quantity.
        /// </summary>
        public int PurchaseUnitQuantity { get; set; }

        /// <summary>
        /// Gets or sets the sale unit.
        /// </summary>
        public int SaleUnit { get; set; }

        /// <summary>
        /// Gets or sets the sale unit quantity.
        /// </summary>
        public int SaleUnitQuantity { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether is batch number.
        /// </summary>
        public bool IsBatchNumber { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether is expiry.
        /// </summary>
        public bool IsExpiry { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the tax.
        /// </summary>
        public string Tax { get; set; }

        /// <summary>
        /// Gets or sets the rack name.
        /// </summary>
        public string RackName { get; set; }

        /// <summary>
        /// Gets or sets the purchase unit name.
        /// </summary>
        public string PurchaseUnitName { get; set; }

        /// <summary>
        /// Gets or sets the sale unit name.
        /// </summary>
        public string SaleUnitName { get; set; }

        /// <summary>
        /// Gets or sets the modified by name.
        /// </summary>
        public string ModifiedByName { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether is product expire.
        /// </summary>
        public bool IsProductExpire { get; set; }

        /// <summary>
        /// Gets or sets the purchase unit qty.
        /// </summary>
        public int PurchaseUnitQty { get; set; }

        /// <summary>
        /// Gets or sets the sale unit qty.
        /// </summary>
        public int SaleUnitQty { get; set; }

        /// <summary>
        /// Gets or sets the rol quantity.
        /// </summary>
        public int RolQuantity { get; set; }

        /// <summary>
        /// Gets or sets the generic name.
        /// </summary>
        public string GenericName { get; set; }

        /// <summary>
        /// Gets or sets the barcode.
        /// </summary>
        public string Barcode { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy product id.
        /// </summary>
        public int PharmacyProductId { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        public int? TotalItems { get; set; }

        /// <summary>
        /// Gets or sets the page size.
        /// </summary>
        public int? PageSize { get; set; }

        /// <summary>
        /// Gets or sets the page index.
        /// </summary>
        public int? PageIndex { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy stock id.
        /// </summary>
        public int PharmacyStockId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy retail stock id.
        /// </summary>
        public int PharmacyRetailStockId { get; set; }

        /// <summary>
        /// Gets or sets the quantity in.
        /// </summary>
        public int QuantityIn { get; set; }

        /// <summary>
        /// Gets or sets the quantity out.
        /// </summary>
        public int QuantityOut { get; set; }

        /// <summary>
        /// Gets or sets the available quantity.
        /// </summary>
        public int AvailableQuantity { get; set; }

        /// <summary>
        /// Gets or sets the batch number.
        /// </summary>
        public string BatchNumber { get; set; }

        /// <summary>
        /// Gets or sets the tax percentage.
        /// </summary>
        public string TaxPercentage { get; set; }

        /// <summary>
        /// Gets or sets the expiry date.
        /// </summary>
        public DateTime? ExpiryDate { get; set; }

        /// <summary>
        /// Gets or sets the mrp.
        /// </summary>
        public double Mrp { get; set; }

        /// <summary>
        /// Gets or sets the login Account value id.
        /// </summary>
        public int? LoginAccountId { get; set; }

        /// <summary>
        /// Gets or sets the login Role value id.
        /// </summary>
        public int? LoginRoleId { get; set; }

        /// <summary>
        /// Gets or sets the is get product id.
        /// </summary>
        public bool IsGetProductId { get; set; }

        /// <summary>
        /// Gets or sets the bulk product ids.
        /// </summary>
        public string BulkProductIds { get; set; }

        /// <summary>
        /// Gets or sets the retail pharmacy id.
        /// </summary>
        public int? RetailPharmacyId { get; set; }

        /// <summary>
        /// Gets or sets the retail pharmacy id.
        /// </summary>
        public int? SupplierProductId { get; set; }

        /// <summary>
        /// Gets or sets the created by name.
        /// </summary>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the bill date.
        /// </summary>
        public DateTime BillDate { get; set; }

        /// <summary>
        /// Gets or sets the bill type.
        /// </summary>
        public string BillType { get; set; }

        /// <summary>
        /// Gets or sets the bill number.
        /// </summary>
        public string BillNumber { get; set; }

        public List<SendEmailModel> EmailProducts { get; set; }
    }

    /// <summary>
    /// The send email model.
    /// </summary>
    public class SendEmailModel
    {
        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the company name.
        /// </summary>
        public string SupplierName { get; set; }

        /// <summary>
        /// Gets or sets the category name.
        /// </summary>
        public string CategoryName { get; set; }

        /// <summary>
        /// Gets or sets the tax.
        /// </summary>
        public string Tax { get; set; }

        /// <summary>
        /// Gets or sets the rack name.
        /// </summary>
        public string RackName { get; set; }

        /// <summary>
        /// Gets or sets the purchase unit name.
        /// </summary>
        public string PurchaseUnitName { get; set; }

        /// <summary>
        /// Gets or sets the sale unit name.
        /// </summary>
        public string SaleUnitName { get; set; }

        /// <summary>
        /// Gets or sets the modified by name.
        /// </summary>
        public string ModifiedByName { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether is product expire.
        /// </summary>
        public bool IsProductExpire { get; set; }

        /// <summary>
        /// Gets or sets the purchase unit qty.
        /// </summary>
        public int PurchaseUnitQty { get; set; }

        /// <summary>
        /// Gets or sets the sale unit qty.
        /// </summary>
        public int SaleUnitQty { get; set; }

        /// <summary>
        /// Gets or sets the rol quantity.
        /// </summary>
        public int RolQuantity { get; set; }

        /// <summary>
        /// Gets or sets the generic name.
        /// </summary>
        public string GenericName { get; set; }

        /// <summary>
        /// Gets or sets the barcode.
        /// </summary>
        public string Barcode { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy product id.
        /// </summary>
        public int PharmacyProductId { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        public int? TotalItems { get; set; }

        /// <summary>
        /// Gets or sets the page size.
        /// </summary>
        public int? PageSize { get; set; }

        /// <summary>
        /// Gets or sets the page index.
        /// </summary>
        public int? PageIndex { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy stock id.
        /// </summary>
        public int PharmacyStockId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy retail stock id.
        /// </summary>
        public int PharmacyRetailStockId { get; set; }

        /// <summary>
        /// Gets or sets the quantity in.
        /// </summary>
        public int QuantityIn { get; set; }

        /// <summary>
        /// Gets or sets the quantity out.
        /// </summary>
        public int QuantityOut { get; set; }

        /// <summary>
        /// Gets or sets the available quantity.
        /// </summary>
        public int AvailableQuantity { get; set; }

        /// <summary>
        /// Gets or sets the batch number.
        /// </summary>
        public string BatchNumber { get; set; }

        /// <summary>
        /// Gets or sets the tax percentage.
        /// </summary>
        public string TaxPercentage { get; set; }

        /// <summary>
        /// Gets or sets the expiry date.
        /// </summary>
        public DateTime? ExpiryDate { get; set; }

        /// <summary>
        /// Gets or sets the purchase rate.
        /// </summary>
        public double PurchaseRate { get; set; }

        /// <summary>
        /// Gets or sets the mrp.
        /// </summary>
        public double Mrp { get; set; }

        /// <summary>
        /// Gets or sets the login Account value id.
        /// </summary>
        public int? LoginAccountId { get; set; }

        /// <summary>
        /// Gets or sets the login Role value id.
        /// </summary>
        public int? LoginRoleId { get; set; }

        /// <summary>
        /// Gets or sets the is get product id.
        /// </summary>
        public bool IsGetProductId { get; set; }

        /// <summary>
        /// Gets or sets the bulk product ids.
        /// </summary>
        public string BulkProductIds { get; set; }

        /// <summary>
        /// Gets or sets the retail pharmacy id.
        /// </summary>
        public int? RetailPharmacyId { get; set; }

        /// <summary>
        /// Gets or sets the retail pharmacy id.
        /// </summary>
        public int? SupplierProductId { get; set; }

        /// <summary>
        /// Gets or sets the quantity.
        /// </summary>
        public float Quantity { get; set; }

        /// <summary>
        /// Gets or sets the email.
        /// </summary>
        public string Email { get; set; }

        /// <summary>
        /// Gets or sets the total.
        /// </summary>
        public double Total { get; set; }

        /// <summary>
        /// Gets or sets the discount amount.
        /// </summary>
        public double? DiscountAmount { get; set; }

        /// <summary>
        /// Gets or sets the free.
        /// </summary>
        public double? Free { get; set; }

        /// <summary>
        /// Gets or sets the net amount.
        /// </summary>
        public double NetAmount { get; set; }

        /// <summary>
        /// Gets or sets the discount per item.
        /// </summary>
        public double? DiscountPerItem { get; set; }

        /// <summary>
        /// Gets or sets the product name.
        /// </summary>
        public string ProductName { get; set; }

        /// <summary>
        /// Gets or sets the tax amount.
        /// </summary>
        public double? TaxAmount { get; set; }
    }

}
