﻿namespace Hims.Shared.EntityModels
{
    using System;
    using System.Collections.Generic;
    using System.Text;

    /// <summary>
    /// The supplier model.
    /// </summary>
    public class SupplierModel
    {
        /// <summary>
        /// Gets or sets the supplier id.
        /// </summary>
        public int SupplierId { get; set; }

        /// <summary>
        /// Gets or sets the address.
        /// </summary>
        public string Address { get; set; }

        /// <summary>
        /// Gets or sets the domain.
        /// </summary>
        /// <value>
        /// The domain.
        /// </value>
        public string Domain { get; set; }

        /// <summary>
        /// Gets or sets the supplier encrypt identifier.
        /// </summary>
        /// <value>
        /// The supplier encrypt identifier.
        /// </value>
        public string SupplierEncryptId { get; set; }

        /// <summary>
        /// Gets or sets the name.
        /// </summary>
        public string Name { get; set; }

        /// <summary>
        /// Gets or sets the mobile.
        /// </summary>
        public string Mobile { get; set; }

        /// <summary>
        /// Gets or sets the email.
        /// </summary>
        public string Email { get; set; }

        /// <summary>
        /// Gets or sets the pin code.
        /// </summary>
        public string PinCode { get; set; }

        /// <summary>
        /// Gets or sets the city.
        /// </summary>
        public string City { get; set; }

        /// <summary>
        /// Gets or sets the supplier of.
        /// </summary>
        public string SupplierOf { get; set; }

        /// <summary>
        /// Gets or sets bank name.
        /// </summary>
        public string BankName { get; set; }

        /// <summary>
        /// Gets or sets the ifsc code.
        /// </summary>
        public string IfscCode { get; set; }

        /// <summary>
        /// Gets or sets the account numbet.
        /// </summary>
        public string AccountNumber { get; set; }

        /// <summary>
        /// Gets or sets the account holder name.
        /// </summary>
        public string AccountHolderName { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime? CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the login Account value id.
        /// </summary>
        public int? LoginAccountId { get; set; }

        /// <summary>
        /// Gets or sets the login Role value id.
        /// </summary>
        public int? LoginRoleId { get; set; }

        /// <summary>
        /// Gets or sets the from date.
        /// </summary>
        public string? FromDate { get; set; }

        /// <summary>
        /// Gets or sets the to date.
        /// </summary>
        public string? ToDate { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        public int? TotalItems { get; set; }

        /// <summary>
        /// Gets or sets the page size.
        /// </summary>
        public int? PageSize { get; set; }

        /// <summary>
        /// Gets or sets the page index.
        /// </summary>
        public int? PageIndex { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int? CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the created by name.
        /// </summary>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the modified by name.
        /// </summary>
        public string ModifiedByName { get; set; }

        /// <summary>
        /// Gets or sets the location identifier.
        /// </summary>
        /// <value>
        /// The location identifier.
        /// </value>
        public int? LocationId { get; set; }

        /// <summary>
        /// Gets or sets the is create account.
        /// </summary>
        /// <value>
        /// The is create account.
        /// </value>
        public bool IsCreateAccount { get; set; }

        /// <summary>
        /// Gets or sets the user identifier.
        /// </summary>
        /// <value>
        /// The user identifier.
        /// </value>
        public int? UserId { get; set; }

        /// <summary>
        /// Gets or sets the due days.
        /// </summary>
        /// <value>
        /// The due days.
        /// </value>
        public int? DueDays { get; set; }

        /// <summary>
        /// Gets or sets the deliver days.
        /// </summary>
        /// <value>
        /// The deliver days.
        /// </value>
        public int? DeliverDays { get; set; }

        /// <summary>
        /// Gets or sets the name of the contact person.
        /// </summary>
        /// <value>
        /// The name of the contact person.
        /// </value>
        public string ContactPersonName { get; set; }

        /// <summary>
        /// Gets or sets the drug license.
        /// </summary>
        /// <value>
        /// The drug license.
        /// </value>
        public string DrugLicense { get; set; }

        /// <summary>
        /// Gets or sets the GST no.
        /// </summary>
        /// <value>
        /// The GST no.
        /// </value>
        public string GSTNo { get; set; }

        /// <summary>
        /// Gets or sets the pan.
        /// </summary>
        /// <value>
        /// The pan.
        /// </value>
        public string Pan { get; set; }

        /// <summary>
        /// Gets or sets the supplier ids.
        /// </summary>
        /// <value>
        /// The supplier ids.
        /// </value>
        public string SupplierIds { get; set; }
    }
}
