﻿namespace Hims.Shared.Library.Enums
{
    /// <summary>
    /// The internal medicine.
    /// </summary>
    public enum BehavioralHealthType
    {
        /// <summary>
        /// The problem history.
        /// </summary>
        ProblemHistory,

        /// <summary>
        /// The medical history.
        /// </summary>
        MedicalHistory,

        /// <summary>
        /// The current support.
        /// </summary>
        CurrentSupport,

        /// <summary>
        /// The current living.
        /// </summary>
        CurrentLiving,

        /// <summary>
        /// The educational history.
        /// </summary>
        EducationalHistory,

        /// <summary>
        /// The client strengths.
        /// </summary>
        ClientStrengths,

        /// <summary>
        /// The out come measures.
        /// </summary>
        OutComeMeasures,

        /// <summary>
        /// The substance history.
        /// </summary>
        SubstanceHistory,

        /// <summary>
        /// The work history.
        /// </summary>
        WorkHistory,

        /// <summary>
        /// The abuse history.
        /// </summary>
        AbuseHistory,

        /// <summary>
        /// The religion spirituality.
        /// </summary>
        ReligionSpirituality,

        /// <summary>
        /// The mental status.
        /// </summary>
        MentalStatus,

        /// <summary>
        /// The family relationships.
        /// </summary>
        FamilyRelationships,

        /// <summary>
        /// The relapse predictors.
        /// </summary>
        RelapsePredictors,

        /// <summary>
        /// The patient questionnaire.
        /// </summary>
        PatientQuestionnaire,

        /// <summary>
        /// The generalised anxiety disorder.
        /// </summary>
        GeneralisedAnxietyDisorder,

        /// <summary>
        /// The burns depression.
        /// </summary>
        BurnsDepression,

        /// <summary>
        /// The aims.
        /// </summary>
        Aims,

        /// <summary>
        /// The geno gram.
        /// </summary>
        Genogram,

        /// <summary>
        /// The notes.
        /// </summary>
        Notes,

        /// <summary>
        /// The vitals.
        /// </summary>
        Vitals,

        /// <summary>
        /// The referral provider.
        /// </summary>
        ReferralProvider,

        /// <summary>
        /// The follow up.
        /// </summary>
        FollowUp,

        /// <summary>
        /// The medications.
        /// </summary>
        Medications,

        /// <summary>
        /// The treatment plan.
        /// </summary>
        TreatmentPlan,

        /// <summary>
        /// The medication comment.
        /// </summary>
        MedicationComment
    }
}
