﻿namespace Hims.Shared.Library.Enums
{
    /// <summary>
    /// The notification intimate.
    /// </summary>
    public enum NotificationIntimate
    {
        /// <summary>
        /// The prescription.
        /// </summary>
        PrescriptionAdded = 1,

        /// <summary>
        /// The prescription updated.
        /// </summary>
        PrescriptionUpdated = 2,

        /// <summary>
        /// The full transcription.
        /// </summary>
        FullTranscriptionAdded = 3,

        /// <summary>
        /// The full transcription updated.
        /// </summary>
        FullTranscriptionUpdated = 4,

        /// <summary>
        /// The documents.
        /// </summary>
        PatientUploadedDocuments = 5,

        /// <summary>
        /// The doctor uploaded documents.
        /// </summary>
        DoctorUploadedDocuments = 6,

        /// <summary>
        /// The documents edit.
        /// </summary>
        PatientEditedDocuments = 7,

        /// <summary>
        /// The doctor edited documents.
        /// </summary>
        DoctorEditedDocuments = 8
    }

    /// <summary>
    /// The roles.
    /// </summary>
    public enum Roles
    {
        /// <summary>
        /// The super admin.
        /// </summary>
        SuperAdmin = 1,

        /// <summary>
        /// The admin.
        /// </summary>
        Administrator,

        /// <summary>
        /// The provider.
        /// </summary>
        Provider,

        /// <summary>
        /// The patient.
        /// </summary>
        Patient,

        /// <summary>
        /// The support.
        /// </summary>
        Support,

        /// <summary>
        /// The nurse.
        /// </summary>
        Nurse,

        /// <summary>
        /// The receptionist.
        /// </summary>
        Receptionist,

        /// <summary>
        /// The accountant.
        /// </summary>
        Accountant,
        
        /// <summary>
        /// The symptom creator.
        /// </summary>
        SymptomCreator,

        /// <summary>
        /// The symptom manager.
        /// </summary>
        SymptomManager
    }
}
