﻿namespace Hims.Shared.UserModels.Discharge
{
    using System;
    /// <summary>
    /// The receipt model
    /// </summary>
    public class InsertModel

    {       
        /// <summary>
        /// Gets or sets the admission identifier.
        /// </summary>
        /// <value>
        /// The admission identifier.
        /// </value>
        public int AdmissionId { get; set; }

        /// <summary>
        /// Gets or sets the identifier.
        /// </summary>
        /// <value>
        /// The identifier.
        /// </value>
        public string Id { get; set; }

        /// <summary>
        /// Gets or sets the discharge date.
        /// </summary>
        /// <value>
        /// The discharge date.
        /// </value>
        public DateTime DischargeDate { get; set; }

        /// <summary>
        /// Gets or sets the condition on discharge.
        /// </summary>
        /// <value>
        /// The condition on discharge.
        /// </value>
        public string ConditionOnDischarge { get; set; }

        /// <summary>
        /// Gets or sets the final diagnosis.
        /// </summary>
        /// <value>
        /// The final diagnosis.
        /// </value>
        public string FinalDiagnosis { get; set; }

        /// <summary>
        /// Gets or sets the history of present illness.
        /// </summary>
        /// <value>
        /// The history of illness.
        /// </value>
        public string HistoryOfIllness { get; set; }

        /// <summary>
        /// Gets or sets the diet.
        /// </summary>
        /// <value>
        /// The diet.
        /// </value>
        public string Diet { get; set; }

        /// <summary>
        /// Gets or sets the discharge summary.
        /// </summary>
        /// <value>
        /// The discharge summary.
        /// </value>
        public string DischargeSummary { get; set; }

        /// <summary>
        /// Gets or sets the discharge follow up date.
        /// </summary>
        /// <value>
        /// The discharge follow up date.
        /// </value>
        public DateTime? DischargeFollowUpDate { get; set; }

        /// <summary>
        /// Gets or sets the discharge follow up days.
        /// </summary>
        /// <value>
        /// The discharge follow up days.
        /// </value>
        public int? DischargeFollowUpDays { get; set; }

        /// <summary>
        /// Gets or sets the follow up summary.
        /// </summary>
        /// <value>
        /// The follow up summary.
        /// </value>
        public string FollowUpSummary { get; set; }

        /// <summary>
        /// Gets or sets the discharge status identifier.
        /// </summary>
        /// <value>
        /// The discharge status identifier.
        /// </value>
        public int DischargeStatusId { get; set; }

        /// <summary>
        /// Gets or sets the is death.
        /// </summary>
        /// <value>
        /// The is death.
        /// </value>
        public bool? IsDeath { get; set; }

        /// <summary>
        /// Gets or sets the death date.
        /// </summary>
        /// <value>
        /// The death date.
        /// </value>
        public DateTime? DeathDate { get; set; }

        /// <summary>
        /// Gets or sets the cause of death.
        /// </summary>
        /// <value>
        /// The cause of death.
        /// </value>
        public string CauseOfDeath { get; set; }

        /// <summary>
        /// Gets or sets the discharge instruction identifier.
        /// </summary>
        /// <value>
        /// The discharge instruction identifier.
        /// </value>
        public string DischargeInstructionId { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this <see cref="Discharge"/> is active.
        /// </summary>
        /// <value>
        ///   <c>true</c> if active; otherwise, <c>false</c>.
        /// </value>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the inserte comments.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// gets or sets the roleId.
        /// </summary>
        public short? RoleId { get; set; }

        /// <summary>
        /// gets or sets the fullName.
        /// </summary>
        public string? FullName { get; set; }


        ///// <summary>
        ///// sets or sets the discharge instruction name.
        ///// </summary>
        //public string? DischargeInstructionName { get; set; }

        //----------------------------
        //for new discharge-Page
        //--------------------------

        /// <summary>
        /// Gets or sets the history of past illness.
        /// </summary>
        /// <value>
        /// The Past history.
        /// </value>
        public string? PastHistory { get; set; }

        /// <summary>
        /// Gets or sets the history of past illness.
        /// </summary>
        /// <value>
        /// The Past history.
        /// </value>
        public string? DischargeAdvise { get; set; }

        /// <summary>
        /// gets or sets the Surgery details.
        /// </summary>
        public string? Surgery { get; set; }

        /// <summary>
        /// Gets or sets list of Surgoen Name .
        /// </summary>
        /// <value>
        /// The provider id (multiple).
        /// </value>
       public string? SurgeonNamesId { get; set; }

        /// <summary>
        /// gets or sets the GeneralExamination.
        /// </summary>
        public string? GeneralExamination { get; set; }

        /// <summary>
        /// gets or sets the LocalExamination.
        /// </summary>
        public string? LocalExamination { get; set; }

        /// <summary>
        /// gets or sets the HospitalCourse.
        /// </summary>
        public string? HospitalCourse { get; set; }

        /// <summary>
        /// gets or sets the OperativeProcedure.
        /// </summary>
        public string? OperativeProcedure { get; set; }

        /// <summary>
        /// gets or sets the OperativeNotes.
        /// </summary>
        public string? OperativeNotes { get; set; }

        /// <summary>
        /// gets or sets the ConsultantSignature.
        /// </summary>
        /// /// <value>
        /// The provider id (single).
        /// </value>
        public int? ConsultantSignature { get; set; }
    }
}
