﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Text;

namespace Hims.Shared.UserModels
{
    public class DoctorAppointmentNoticeModel
    {
        public int DoctorAppointmentNoticeId { get; set; }

        public int LocationId { get; set; }

        public int? ProviderId { get; set; }

        public string? FromDate { get; set; }

        public string? ToDate { get; set; }

        public string Description { get; set; }

        public bool? Active { get; set; }

        public int? CreatedBy { get; set; }

        public DateTime? CreatedDate { get; set; }

        public int? ModifiedBy { get; set; }

        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        public int? TotalItems { get; set; }

        /// <summary>
        /// Gets or sets the page index.
        /// </summary>
        public int? PageIndex { get; set; }

        /// <summary>
        /// Gets or sets the page size.
        /// </summary>
        public int? PageSize { get; set; }
        
        /// <summary>
        /// GEts or sets the provider name.
        /// </summary>
        public string? ProviderName { get; set; }

        /// <summary>
        /// Gets or sets the location name.
        /// </summary>
        public string? LocationName { get; set; }

        /// <summary>
        /// Gets or Sets the modified By Name.
        /// </summary>
        public string? ModifiedByName { get; set; }

        /// <summary>
        /// Gets or sets the login role
        /// </summary>
        public short? LoginRoleId { get; set; }

        /// <summary>
        /// Gets or sets the charge category name.
        /// </summary>
        public string CreatedByName { get; set; }
    }
}
