﻿#nullable enable
using System;

namespace Hims.Shared.UserModels.Filters
{
    /// <summary>
    /// The patient filter model.
    /// </summary>
    public class EmployeeRevenueReportsFilterModel
    {
        /// <summary>
        /// Gets or sets the Provider id.
        /// </summary>
        public int? AccountId { get; set; }

        /// <summary>
        /// Gets or sets the Provider id.
        /// </summary>
        public int? RoleId { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public string FromDate { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the optional text 2.
        /// </summary>
        public string ToDate { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the value.
        /// </summary>
        public string AdmissionNo { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the type.
        /// </summary>
        public string Type { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the page index.
        /// </summary>
        public int PageIndex { get; set; }

        /// <summary>
        /// Gets or sets the page size.
        /// </summary>
        public int PageSize { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        public int TotalItems { get; set; }
        /// <summary>
        /// Gets or sets the patient name.
        /// </summary>
        public string PatientName { get; set; } = string.Empty;
        /// <summary>
        /// Gets or sets the umr no.
        /// </summary>
        public string UMRNo { get; set; } = string.Empty;
        /// <summary>
        /// Gets or sets the patient mobile.
        /// </summary>
        public string PatientMobile { get; set; } = string.Empty;
        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        public int? PatientId { get; set; }

        /// <summary>
        /// Gets or sets the appointment no.
        /// </summary>
        public string AppointmentNo { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the receipt Id.
        /// </summary>
        public string? ReceiptId { get; set; }

        /// <summary>
        /// Gets or sets the Provider id.
        /// </summary>
        public int? ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the Provider id.
        /// </summary>
        public int  LocationId { get; set; }
    }
}
