﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Hims.Shared.UserModels.Labs
{
    /// <summary>
    /// The LabChargeCategoryModel.
    /// </summary>
    public class LabChargeCategoryModel
    {
        /// <summary>
        /// Gets or sets the charge category identifier.
        /// </summary>
        /// <value>
        /// The charge category identifier.
        /// </value>
        public int ChargeCategoryId { get; set; }
        /// <summary>
        /// Gets or sets the location identifier.
        /// </summary>
        /// <value>
        /// The location identifier.
        /// </value>
        public int? LocationId { get; set; }
        /// <summary>
        /// Gets or sets a value indicating whether this <see cref="LabChargeCategoryModel"/> is active.
        /// </summary>
        /// <value>
        ///   <c>true</c> if active; otherwise, <c>false</c>.
        /// </value>
        public bool? Active { get; set; }
        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int? CreatedBy { get; set; }
        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime? CreatedDate { get; set; }
        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        /// <value>
        /// The modified by.
        /// </value>
        public int? ModifiedBy { get; set; }
        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        /// <value>
        /// The modified date.
        /// </value>
        public DateTime? ModifiedDate { get; set; }
        /// <summary>
        /// Gets or sets the name of the charge category.
        /// </summary>
        /// <value>
        /// The name of the charge category.
        /// </value>
        public string ChargeCategoryName { get; set; }
        /// <summary>
        /// Gets or sets a value indicating whether this <see cref="LabChargeCategoryModel"/> is default.
        /// </summary>
        /// <value>
        ///   <c>true</c> if default; otherwise, <c>false</c>.
        /// </value>
        public bool? Default { get; set; }
    }
}
