﻿namespace Hims.Shared.UserModels.Pharmacy
{
    using System.Collections.Generic;

    /// <summary>
    /// The raw purchase bill model.
    /// </summary>
    public class RawPurchaseBillModel
    {
        /// <summary>
        /// Gets or sets the supplier name.
        /// </summary>
        public string SupplierName { get; set; }

        /// <summary>
        /// Gets or sets the bill number.
        /// </summary>
        public string BillNumber { get; set; }

        /// <summary>
        /// Gets or sets the batch number.
        /// </summary>
        public string BatchNumber { get; set; }

        /// <summary>
        /// Gets or sets the name of the sheet.
        /// </summary>
        /// <value>
        /// The name of the sheet.
        /// </value>
        public string SheetName { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy ware house identifier.
        /// </summary>
        /// <value>
        /// The pharmacy ware house identifier.
        /// </value>
        public int? PharmacyWareHouseId { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the excel upload history identifier.
        /// </summary>
        /// <value>
        /// The excel upload history identifier.
        /// </value>
        public int ExcelUploadHistoryId { get; set; }

        /// <summary>
        /// Gets or sets the products.
        /// </summary>
        /// <value>
        /// The products.
        /// </value>
        public List<RawProductsModel> Products { get; set; }

        /// <summary>
        /// Gets or sets the value indicating is create log.
        /// </summary>
        public bool IsCreateLog { get; set; }
    }
}
