﻿namespace Hims.Shared.UserModels.ProgressReport.Vitals
{
    using System;

    /// <summary>
    /// The view model.
    /// </summary>
    public class ViewModel
    {
        /// <summary>
        /// Gets or sets the progress report vitals id.
        /// </summary>
        public int ProgressReportVitalsId { get; set; }

        /// <summary>
        /// Gets or sets the progress report id.
        /// </summary>
        public int ProgressReportId { get; set; }

        /// <summary>
        /// Gets or sets the date.
        /// </summary>
        public DateTime Date { get; set; }

        /// <summary>
        /// Gets or sets the vital type id.
        /// </summary>
        public int VitalTypeId { get; set; }
        
        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by name.
        /// </summary>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime? CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by name.
        /// </summary>
        public string ModifiedByName { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the vital type value.
        /// </summary>
        public int VitalTypeValue { get; set; }

        /// <summary>
        /// Gets or sets the duration.
        /// </summary>
        public string Vitals { get; set; }

        /// <summary>
        /// Gets or sets the unit name.
        /// </summary>
        public string? UnitName { get; set; }

        /// <summary>
        /// Gets or sets the created by role
        /// </summary>
        public string? CreatedByRole { get; set; }

        /// <summary>
        /// Gets or sets the Created by Role.
        /// </summary>
        public string? ModifiedByRole { get; set; }
    }
}
