﻿namespace Hims.Shared.UserModels
{
    using System.Collections.Generic;
    using System.Diagnostics.CodeAnalysis;

    /// <summary>
    /// The provider shift model.
    /// </summary>
    public class ProviderShiftModel
    {
        /// <summary>
        /// Gets or sets the day.
        /// </summary>
        public short Day { get; set; }

        /// <summary>
        /// Gets or sets the consultation charges.
        /// </summary>
        public decimal? ConsultationCharges { get; set; }

        /// <summary>
        /// Gets or sets the telemedicine charges.
        /// </summary>
        public decimal? TelemedicineCharges { get; set; }

        /// <summary>
        /// Gets or sets the in patient charges.
        /// </summary>
        public decimal? InPatientCharges { get; set; }

        /// <summary>
        /// Gets or sets the out patient charges.
        /// </summary>
        public decimal? OutPatientCharges { get; set; }

        /// <summary>
        /// Gets or sets the casualty charges.
        /// </summary>
        public decimal? CasualtyCharges { get; set; }

        /// <summary>
        /// Gets or sets the covid charges.
        /// </summary>
        public decimal? CovidCharges { get; set; }

        /// <summary>
        /// Gets or sets the special charges.
        /// </summary>
        public decimal? SpecialCharges { get; set; }

        /// <summary>
        /// Gets or sets the consultation Fallow Up charges.
        /// </summary>
        public decimal? ConsultationFallowUpCharges { get; set; }

        /// <summary>
        /// Gets or sets the in patient Fallow Up charges.
        /// </summary>
        public decimal? InPatientFallowUpCharges { get; set; }

        /// <summary>
        /// Gets or sets the out patient Fallow Up charges.
        /// </summary>
        public decimal? OutPatientFallowUpCharges { get; set; }

        /// <summary>
        /// Gets or sets the casualty Fallow Up charges.
        /// </summary>
        public decimal? CasualtyFallowUpCharges { get; set; }

        /// <summary>
        /// Gets or sets the telemedicine Fallow Up charges.
        /// </summary>
        public decimal? TelemedicineFallowUpCharges { get; set; }

        /// <summary>
        /// Gets or sets the in follow up days for op.
        /// </summary>
        public decimal? FollowUpDaysChargesForOp { get; set; }

        /// <summary>
        /// Gets or sets the op follow up days for ip.
        /// </summary>
        public decimal? OpFollowUpDaysChargesForIp { get; set; }

        /// <summary>
        /// Gets or sets the slots.
        /// </summary>
        public List<SlotsModel> Slots { get; set; }

        /// <summary>
        /// Gets or sets the charge type.
        /// </summary>
        public List<VisitChargeModel> ChargeType { get; set; }
    }

    /// <summary>
    /// The slots model.
    /// </summary>
    [SuppressMessage("StyleCop.CSharp.MaintainabilityRules", "SA1402:FileMayOnlyContainASingleClass", Justification = "Reviewed. Suppression is OK here.")]
    public class SlotsModel
    {
        /// <summary>
        /// Gets or sets the duration.
        /// </summary>
        public string Duration { get; set; }

        /// <summary>
        /// Gets or sets the from time.
        /// </summary>
        public string FromTime { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the to time.
        /// </summary>
        public string ToTime { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the specializations.
        /// </summary>
        public List<int> Specializations { get; set; }
    }

    /// <summary>
    /// The slots model.
    /// </summary>
    [SuppressMessage("StyleCop.CSharp.MaintainabilityRules", "SA1402:FileMayOnlyContainASingleClass", Justification = "Reviewed. Suppression is OK here.")]
    public class VisitChargeModel
    {
        /// <summary>
        /// Gets or sets the type.
        /// </summary>
        public int TypeId { get; set; }

        /// <summary>
        /// Gets or sets the value.
        /// </summary>
        public string Name { get; set; }

        /// <summary>
        /// Gets or sets the value.
        /// </summary>
        public int Value { get; set; }
    }
}
