﻿using Hims.Shared.UserModels.PatientExcel;
using System;


namespace Hims.Shared.UserModels.Scan.ScanAppointment
{
    /// <summary>
    /// The book scan appointment.
    /// </summary>
    public class InsertBookScanAppointment
    {
        /// <summary>
        /// Gets or sets the book scan appointment id.
        /// </summary>
        public int? BookScanAppointmentId { get; set; }

        /// <summary>
        /// Gets or sets the json patient Details.
        /// </summary>
        public string? patientDetails { get; set; }

        ///// <summary>
        ///// Gets or sets the json patient Details.
        ///// </summary>
        //public ModifyPatientRequest? patientJsonDetails { get; set; }

        /// <summary>
        /// Gets or sets the scan machine master id.
        /// </summary>
        public int ScanMachineMasterId { get; set; }

        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        public int PatientId { get; set; }

        /// <summary>
        /// Gets or sets the payment status.
        /// </summary>
        public bool PaymentStatus { get; set; }

        /// <summary>
        /// Gets or sets the pay type id.
        /// </summary>
        public int? PayTypeId { get; set; }

        /// <summary>
        /// Gets or sets the location id.
        /// </summary>
        public int LocationId { get; set; }

        /// <summary>
        /// Gets or sets the location name.
        /// </summary>
        public string LocationName { get; set; }

        /// <summary>
        /// Gets or sets the login role id.
        /// </summary>
        public int? LoginRoleId { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime? CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the appointment date.
        /// </summary>
        public DateTime AppointmentDate { get; set; }

        /// <summary>
        /// Gets or sets the appointment time.
        /// </summary>
        public string AppointmentTime { get; set; }

        /// <summary>
        /// Gets or sets the created by name.
        /// </summary>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the patient name.
        /// </summary>
        public string? PatientName { get; set; }

        /// <summary>
        /// Gets or sets the payment number.
        /// </summary>
        public string? PaymentNumber { get; set; }

        /// <summary>
        /// Gets or sets the scan test master id.
        /// </summary>
        public int ScanTestMasterId { get; set; }

        /// <summary>
        /// Gets or sets the charge category id.
        /// </summary>
        public int? ChargeCategoryId { get; set; }

        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        public string? Status { get; set; } = "B";

        /// <summary>
        /// Gets or sets the booked status.
        /// </summary>
        public string? BookedStatus { get; set; }

        /// <summary>
        /// Gets or sets the gender.
        /// </summary>
        public char? Gender { get; set; }

        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        public string? Reason { get; set; }

        /// <summary>
        /// Gets or sets the appointment end time.
        /// </summary>
        public string AppointmentEndTime { get; set; }

        /// <summary>
        /// Gets or sets the log from.
        /// </summary>
        public int? LogFrom { get; set; }

        /// <summary>
        /// Gets or sets the amount.
        /// </summary>
        public double Amount { get; set; }

        /// <summary>
        /// Gets or sets the paid amount.
        /// </summary>
        public double? PaidAmount { get; set; }

        /// <summary>
        /// Gets or sets the partially paid amount.
        /// </summary>
        public double? PartialAmount { get; set; }

        /// <summary>
        /// Gets or sets the amount.
        /// </summary>
        public decimal? Charges { get; set; }

        /// <summary>
        /// Gets or sets the amount.
        /// </summary>
        public double? TotalAmt { get; set; }

        /// <summary>
        /// Gets or sets the total.
        /// </summary>
        public double? Total { get; set; }

        /// <summary>
        /// Gets or sets the transaction id.
        /// </summary>
        public string? TransactionId { get; set; }

        /// <summary>
        /// Gets or sets the transaction.
        /// </summary>
        public string? Transaction { get; set; }

        /// <summary>
        /// Gets or sets the transaction id.
        /// </summary>
        public int? SalucroStatusCode { get; set; }

        /// <summary>
        /// Gets or sets the transaction id.
        /// </summary>
        public string? SalucroTransactionId { get; set; }

        /// <summary>
        /// Gets or sets the is salucro appointment.
        /// </summary>
        public bool IsSalucroAppointment { get; set; }

        /// <summary>
        /// Gets or sets the name of the machine.
        /// </summary>
        /// <value>
        /// The name of the machine.
        /// </value>
        public string MachineName { get; set; }

        /// <summary>
        /// Gets or sets the name of the scan test.
        /// </summary>
        public string ScanTestName { get; set; }

        /// <summary>
        /// Gets or sets the mobile.
        /// </summary>
        public string? Mobile { get; set; } = string.Empty;

        ///// <summary>
        ///// Gets or sets the full name.
        ///// </summary>
        //public string? FullName { get; set; }

        /// <summary>
        /// Gets or sets the first name.
        /// </summary>
        public string FirstName { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the last name.
        /// </summary>
        public string LastName { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the address.
        /// </summary>
        public string? Address { get; set; }

        /// <summary>
        /// Gets or sets the Age.
        /// </summary>
        public int? Age { get; set; }

        /// <summary>
        /// Gets or sets the RelationType.
        /// </summary>
        public string? RelationType { get; set; }
        /// <summary>
        /// Gets or sets the RelativeMobile.
        /// </summary>
        public string? RelativeMobile { get; set; }

        /// <summary>
        /// Gets or sets the RelativeName.
        /// </summary>
        public string? RelativeName { get; set; }

        /// <summary>
        /// Gets or sets the RelativeName.
        /// </summary>
        public string ApptDate { get; set; }

        /// <summary>
        /// Gets or sets the Category.
        /// </summary>
        public string Category { get; set; }

        /// <summary>
        /// Gets or sets the Indication.
        /// </summary>
        public string Indication { get; set; }

        /// <summary>
        /// Gets or sets the authorityId.
        /// </summary>
        public int? AuthorityId { get; set; }

        /// <summary>
        /// Gets or sets the reasonId.
        /// </summary>
        public int? ReasonId { get; set; }

        /// <summary>
        /// Gets or sets the discountPerItem.
        /// </summary>
        public int? DiscountPerItem { get; set; }

        /// <summary>
        /// Gets or sets the discountPerItemInRupees.
        /// </summary>
        public double? DiscountPerItemInRupees { get; set; }

        /// <summary>
        /// Gets or sets the total amount.
        /// </summary>
        /// <value>
        /// The total amount.
        /// </value>
        public double? TotalAmount { get; set; }

        /// <summary>
        /// Gets or sets the insurance id.
        /// </summary>
        public string TypeOfPayment { get; set; }

        /// <summary>
        /// Gets or sets the amount.
        /// </summary>
        public double AmountCharges { get; set; }

        /// <summary>
        /// Gets or sets the Pndt Report.
        /// </summary>
        public bool PndtReport { get; set; }

        /// <summary>
        /// Gets or sets the Scan Scroll Result id.
        /// </summary>
        public int? ScanScrollResult { get; set; }

        /// <summary>
        /// Gets or sets the Gravida.
        /// </summary>
        public string Gravida { get; set; }

        /// <summary>
        /// Gets or sets the Period Of Gestation.
        /// </summary>
        public string PeriodOfGestation { get; set; }

        /// <summary>
        /// Gets or sets the Obstetric.
        /// </summary>
        public bool? Obstetric { get; set; }

        /// <summary>
        /// Gets or sets the EDD.
        /// </summary>
        public DateTime? EDD { get; set; }

        /// <summary>
        /// Gets or sets the AccompaniedBy.
        /// </summary>
        public string AccompaniedBy { get; set; }

        /// <summary>
        /// Gets or sets the Findings.
        /// </summary>
        public string Findings { get; set; }

        /// <summary>
        /// Gets or sets the Remarks.
        /// </summary>
        public string Remarks { get; set; }

        /// <summary>
        /// Gets or sets the Reasons.
        /// </summary>
        public string Reasons { get; set; }

        /// <summary>
        /// Gets or sets the Dispatched.
        /// </summary>
        public string Dispatched { get; set; }

        /// <summary>
        /// Gets or sets the BabyDetails.
        /// </summary>
        public string BabyDetails { get; set; }

        /// <summary>
        /// Gets or sets the is dispatched value.
        /// </summary>
        public bool IsDispatched { get; set; }

        /// <summary>
        /// Gets or sets the provider id.
        /// </summary>
        public int ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the patient discount in percentage.
        /// </summary>
        public decimal? PatientDiscountInPercentage { get; set; }

        /// <summary>
        /// Gets or sets the patient discount in rupees.
        /// </summary>
        public decimal? PatientDiscountInRupees { get; set; }

        /// <summary>
        /// Gets or sets the patient total.
        /// </summary>
        public decimal? PatientTotal { get; set; }

        /// <summary>
        /// Gets or sets the appointment discount in percentage.
        /// </summary>
        public decimal? AppointmentDiscountInPercentage { get; set; }

        /// <summary>
        /// Gets or sets the appointment discount in rupees.
        /// </summary>
        public decimal? AppointmentDiscountInRupees { get; set; }

        /// <summary>
        /// Gets or sets the appointment total.
        /// </summary>
        public decimal? AppointmentTotal { get; set; }

        /// <summary>
        /// Gets or sets the after discount amount.
        /// </summary>
        public decimal? AfterDiscount { get; set; }
    }
}
