﻿using System;

namespace Hims.Shared.UserModels.Vendors
{

    /// <summary>
    /// The purchase order detail.
    /// </summary>
    public class PurchaseOrderDetailModel
    {
        /// <summary>
        /// Gets or sets the purchase order detail identifier.
        /// </summary>
        /// <value>
        /// The purchase order detail identifier.
        /// </value>
        public long PurchaseOrderDetailId { get; set; }

        /// <summary>
        /// Gets or sets the purchase order header identifier.
        /// </summary>
        /// <value>
        /// The purchase order header identifier.
        /// </value>
        public long PurchaseOrderHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy product approval identifier.
        /// </summary>
        /// <value>
        /// The pharmacy product approval identifier.
        /// </value>
        public long PharmacyProductApprovalId { get; set; }

        /// <summary>
        /// Gets or sets the purchase order header ids.
        /// </summary>
        /// <value>
        /// The purchase order header ids.
        /// </value>
        public string PurchaseOrderHeaderIds { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy product identifier.
        /// </summary>
        /// <value>
        /// The pharmacy product identifier.
        /// </value>
        public int PharmacyProductId { get; set; }

        /// <summary>
        /// Gets or sets the quantity.
        /// </summary>
        /// <value>
        /// The quantity.
        /// </value>
        public int Quantity { get; set; }

        /// <summary>
        /// Gets or sets the free.
        /// </summary>
        /// <value>
        /// The free.
        /// </value>
        public int Free { get; set; }
                
        /// <summary>
        /// Gets or sets the purchase free.
        /// </summary>
        /// <value>
        /// The purchase free.
        /// </value>
        public int? PurchaseFree { get; set; }

        /// <summary>
        /// Gets or sets the amount.
        /// </summary>
        /// <value>
        /// The amount.
        /// </value>
        public double Amount { get; set; }

        /// <summary>
        /// Gets or sets the tax amount.
        /// </summary>
        /// <value>
        /// The tax amount.
        /// </value>
        public double TaxAmount { get; set; }

        /// <summary>
        /// Gets or sets the net amount.
        /// </summary>
        /// <value>
        /// The net amount.
        /// </value>
        public double NetAmount { get; set; }

        /// <summary>
        /// Gets or sets the MRP.
        /// </summary>
        /// <value>
        /// The MRP.
        /// </value>
        public double Mrp { get; set; }

        /// <summary>
        /// Gets or sets the purchase rate.
        /// </summary>
        /// <value>
        /// The purchase rate.
        /// </value>
        public double PurchaseRate { get; set; }

        /// <summary>
        /// Gets or sets the name of the product.
        /// </summary>
        /// <value>
        /// The name of the product.
        /// </value>
        public string ProductName { get; set; }

        /// <summary>
        /// Gets or sets the name of the generic.
        /// </summary>
        /// <value>
        /// The name of the generic.
        /// </value>
        public string GenericName { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is general item.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is general item; otherwise, <c>false</c>.
        /// </value>
        public bool IsGeneralItem { get; set; }

        /// <summary>
        /// Gets or sets the company identifier.
        /// </summary>
        /// <value>
        /// The company identifier.
        /// </value>
        public int CompanyId { get; set; }

        /// <summary>
        /// Gets or sets the category identifier.
        /// </summary>
        /// <value>
        /// The category identifier.
        /// </value>
        public int CategoryId { get; set; }

        /// <summary>
        /// Gets or sets the tax identifier.
        /// </summary>
        /// <value>
        /// The tax identifier.
        /// </value>
        public int TaxId { get; set; }

        /// <summary>
        /// Gets or sets the tax.
        /// </summary>
        /// <value>
        /// The tax.
        /// </value>
        public int Tax { get; set; }

        /// <summary>
        /// Gets or sets the name of the category.
        /// </summary>
        /// <value>
        /// The name of the category.
        /// </value>
        public string CategoryName { get; set; }

        /// <summary>
        /// Gets or sets the name of the company.
        /// </summary>
        /// <value>
        /// The name of the company.
        /// </value>
        public string CompanyName { get; set; }

        /// <summary>
        /// Gets or sets the name of the type.
        /// </summary>
        /// <value>
        /// The name of the type.
        /// </value>
        public string TypeName { get; set; }

        /// <summary>
        /// Gets or sets the name of the sub type.
        /// </summary>
        /// <value>
        /// The name of the sub type.
        /// </value>
        public string SubTypeName { get; set; }

        /// <summary>
        /// Gets or sets the purchase unit qty.
        /// </summary>
        /// <value>
        /// The purchase unit qty.
        /// </value>
        public int PurchaseUnitQty { get; set; }

        /// <summary>
        /// Gets or sets the sale unit qty.
        /// </summary>
        /// <value>
        /// The sale unit qty.
        /// </value>
        public int SaleUnitQty { get; set; }

        /// <summary>
        /// Gets or sets the name of the purchase unit.
        /// </summary>
        /// <value>
        /// The name of the purchase unit.
        /// </value>
        public string PurchaseUnitName { get; set; }

        /// <summary>
        /// Gets or sets the name of the sale unit.
        /// </summary>
        /// <value>
        /// The name of the sale unit.
        /// </value>
        public string SaleUnitName { get; set; }

        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        /// <value>
        /// The status.
        /// </value>
        public string Status { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is expiry.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is expiry; otherwise, <c>false</c>.
        /// </value>
        public bool IsExpiry { get; set; }

        /// <summary>
        /// Gets or sets the feeded quantity.
        /// </summary>
        /// <value>
        /// The feeded quantity.
        /// </value>
        public int? FeededQuantity { get; set; }

        /// <summary>
        /// Gets or sets the feed purchase rate.
        /// </summary>
        /// <value>
        /// The feed purchase rate.
        /// </value>
        public double? FeedPurchaseRate { get; set; }

        /// <summary>
        /// Gets or sets the feed MRP.
        /// </summary>
        /// <value>
        /// The feed MRP.
        /// </value>
        public double? FeedMrp { get; set; }

        /// <summary>
        /// Gets or sets the tax per item.
        /// </summary>
        /// <value>
        /// The tax per item.
        /// </value>
        public double? TaxPerItem { get; set; }

        /// <summary>
        /// Gets or sets the feed tax amount.
        /// </summary>
        /// <value>
        /// The feed tax amount.
        /// </value>
        public double? FeedTaxAmount { get; set; }

        /// <summary>
        /// Gets or sets the discount per item.
        /// </summary>
        /// <value>
        /// The discount per item.
        /// </value>
        public double? DiscountPerItem { get; set; }

        /// <summary>
        /// Gets or sets the discount amount.
        /// </summary>
        /// <value>
        /// The discount amount.
        /// </value>
        public double? DiscountAmount { get; set; }

        /// <summary>
        /// Gets or sets the feed net amount.
        /// </summary>
        /// <value>
        /// The feed net amount.
        /// </value>
        public double? FeedNetAmount { get; set; }

        /// <summary>
        /// Gets or sets the feed total.
        /// </summary>
        /// <value>
        /// The feed total.
        /// </value>
        public double? FeedTotal { get; set; }

        /// <summary>
        /// Gets or sets the batch number.
        /// </summary>
        /// <value>
        /// The batch number.
        /// </value>
        public string BatchNumber { get; set; }

        /// <summary>
        /// Gets or sets the expiry date.
        /// </summary>
        /// <value>
        /// The expiry date.
        /// </value>
        public DateTime? ExpiryDate { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy purchase detail identifier.
        /// </summary>
        /// <value>
        /// The pharmacy purchase detail identifier.
        /// </value>
        public int? PharmacyPurchaseDetailId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy purchase header identifier.
        /// </summary>
        /// <value>
        /// The pharmacy purchase header identifier.
        /// </value>
        public int? PharmacyPurchaseHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the barcode.
        /// </summary>
        /// <value>
        /// The barcode.
        /// </value>
        public string Barcode { get; set; }

        /// <summary>
        /// Gets or sets the source.
        /// </summary>
        /// <value>
        /// The source.
        /// </value>
        public string Source { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether inventory item.
        /// </summary>
        /// <value>
        ///   <c>true</c> if [inventory item]; otherwise, <c>false</c>.
        /// </value>
        public bool InventoryItem { get; set; }
    }
}
