﻿namespace Hims.Domain.Configurations
{
    /// <summary>
    /// The Application Configuration.
    /// </summary>
    public interface IApplicationConfiguration
    {
        /// <summary>
        /// Gets the version.
        /// </summary>
        string Version { get; }

        /// <summary>
        /// Gets a value indicating whether maintenance.
        /// </summary>
        bool Maintenance { get; }

        /// <summary>
        /// Gets the payment link.
        /// </summary>
        string PaymentLink { get; }

        /// <summary>
        /// Gets the create password link.
        /// </summary>
        string CreatePasswordLink { get; }

        /// <summary>
        /// Gets the reset password link.
        /// </summary>
        string ResetPasswordLink { get; }

        /// <summary>
        /// Gets the base url.
        /// </summary>
        string BaseUrl { get; }

        /// <summary>
        /// Gets the API link.
        /// </summary>
        string APILink { get; }

        /// <summary>
        /// Gets the IOS app url.
        /// </summary>
        string IOSAppLink { get; }

        /// <summary>
        /// Gets the Android app url.
        /// </summary>
        string AndroidAppLink { get; }

        /// <summary>
        /// Gets the website url.
        /// </summary>
        string WebsiteLink { get; }

        /// <summary>
        /// Gets the provider portal url.
        /// </summary>
        string ProviderPortalLink { get; }

        /// <summary>
        /// Gets the provider portal url.
        /// </summary>
        string AdminPortalLink { get; }

        /// <summary>
        /// Gets the mail templates images url.
        /// </summary>
        string MailTemplatesImagesLink { get; }

        /// <summary>
        /// Gets the default email.
        /// </summary>
        string DefaultEmail { get; }

        /// <summary>
        /// Gets the email.
        /// </summary>
        string Email { get; }

        /// <summary>
        /// Gets the default mobile.
        /// </summary>
        string DefaultMobile { get; }

        /// <summary>
        /// Gets the default allow SMS Sending.
        /// </summary>
        bool AllowSMSSending { get; }

        /// <summary>
        /// Gets the default allow video call.
        /// </summary>
        bool AllowVideoCall { get; }

        /// <summary>
        /// Gets the front end link.
        /// </summary>
        string FrontEndLink { get; }

        /// <summary>
        /// Gets the tiny URL link.
        /// </summary>
        /// <value>
        /// The tiny URL link.
        /// </value>
        string TinyUrlLink { get; }

        /// <summary>
        /// Gets the tiny URL authentication token.
        /// </summary>
        /// <value>
        /// The tiny URL authentication token.
        /// </value>
        string TinyUrlAuthToken { get; }

        /// <summary>
        /// Gets the firebase database.
        /// </summary>
        /// <value>
        /// The firebase database.
        /// </value>
        string FirebaseDatabase { get; }

        /// <summary>
        /// Gets the firebase authentication key.
        /// </summary>
        /// <value>
        /// The firebase authentication key.
        /// </value>
        string FirebaseAuthKey { get; }

        /// <summary>
        /// Gets the salucro payment link.
        /// </summary>
        string SalucroPaymentLink { get; }

        /// <summary>
        /// Gets the salucro patient payment link.
        /// </summary>
        string SalucroPatientPaymentLink { get; }
    }
}