﻿using Hims.Shared.Dapper.Attributes;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Text;
#nullable enable
namespace Hims.Domain.Entities
{
    /// <summary>
    /// The MasterOperatingRoom.
    /// </summary>
    public class MasterOperatingRoom
    {
        /// <summary>
        /// Gets or sets the master operating room identifier.
        /// </summary>
        /// <value>
        /// The master operating room identifier.
        /// </value>
        [Key, Identity]
        public int MasterOperatingRoomId { get; set; }

        /// <summary>
        /// Gets or sets the name of the master operating room.
        /// </summary>
        /// <value>
        /// The name of the master operating room.
        /// </value>
        public string? MasterOperatingRoomName { get; set; }


        /// <summary>
        /// Gets or sets the locations.
        /// </summary>
        /// <value>
        /// The locations.
        /// </value>
        public Array? Locations { get; set; } = null;

        /// <summary>
        /// Gets or sets the comments.
        /// </summary>
        /// <value>
        /// The comments.
        /// </value>
        public string? Comments { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this <see cref="MasterOperatingRoom"/> is active.
        /// </summary>
        /// <value>
        ///   <c>true</c> if active; otherwise, <c>false</c>.
        /// </value>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        [IgnoreUpdate]
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        /// <value>
        /// The modified by.
        /// </value>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        [IgnoreUpdate]
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        /// <value>
        /// The modified date.
        /// </value>
        public DateTime? ModifiedDate { get; set; }
    }
}
