﻿#nullable enable
namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The patient insurance.
    /// </summary>
    public class PatientInsurance
    {
        /// <summary>
        /// Gets or sets the patient insurance id.
        /// </summary>
        [Key, Identity]
        public int PatientInsuranceId { get; set; }

        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        public int PatientId { get; set; }

        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        public int InsuranceTypeId { get; set; }

        /// <summary>
        /// Gets or sets the insurance company id.
        /// </summary>
        public int InsuranceCompanyId { get; set; }

        /// <summary>
        /// Gets or sets the validity.
        /// </summary>
        public DateTime Validity { get; set; }

        /// <summary>
        /// Gets or sets the card no.
        /// </summary>
        public string CardNo { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        [IgnoreUpdate]
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        [IgnoreUpdate]
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }
    }
}
