﻿namespace Hims.Domain.Services
{
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Shared.EntityModels;

    /// <summary> The ChatService interface.</summary>
    public interface IChatService
    {
        /// <summary> The fetch all chat async.</summary>
        /// <param name="senderId"> The sender id.</param>
        /// <param name="senderType"> The sender type.</param>
        /// <param name="receiverId"> The receiver id.</param>
        /// <param name="receiverType"> The receiver type.</param>
        /// <param name="date"> The date.</param>
        /// <returns>The <see cref="Task"/>.</returns>
        Task<IEnumerable<ChatModel>> FetchAsync(string senderId, string senderType, string receiverId, string receiverType, string date);

        /// <summary> The save async.</summary>
        /// <param name="chatModel"> The chat model.</param>
        /// <returns>The <see cref="Task"/>.</returns>
        Task<int> SaveAsync(ChatModel chatModel);

        /// <summary>The delete async.</summary>
        /// <param name="chatId">The chat id.</param>
        /// <returns>The <see cref="Task"/>.</returns>
        Task<int> DeleteAsync(long chatId);

        /// <summary>The fetch chat async by chat id.</summary>
        /// <param name="chatId">The chat id.</param>
        /// <returns>The <see cref="Task"/>.</returns>
        Task<ChatModel> FindAsync(long chatId);
    }
}
