﻿namespace Hims.Domain.Services
{
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Hims.Shared.UserModels.Filters;
    using Hims.Shared.UserModels;
    using Shared.Library;
    using Hims.Shared.UserModels.Pharmacy;
    using Hims.Shared.UserModels.Common;
    using Hims.Domain.Entities;
    using Hims.Shared.EntityModels;
    using System;
    using Hims.Shared.UserModels.Scan.ScanAppointment;
    using Hims.Shared.UserModels.MasterBill;
    using FilterModel = Shared.UserModels.MasterBill.FilterModel;
    using Hims.Shared.UserModels.Reports;
    using Hims.Shared.UserModels.Labs;
    using Hims.Shared.UserModels.Labs.Report;


    /// <summary>
    /// The ResourceService interface.
    /// </summary>
    public interface IReportService
    {
        /// <summary>
        /// The patients async.
        /// </summary>
        /// <param name="model"></param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Report>> InPatientsAsync(PatientFilterModel model);

        /// <summary>
        /// The patients async.
        /// </summary>
        /// <param name="model"></param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<PharamacyReport>> FetchInPharamctReportAsync(PharmacyReportFilterModel model);

        /// <summary>
        /// The daily sales async.
        /// </summary>
        /// <param name="model"></param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<DailySalesMedicationModel>> FetchDailySalesReportAsync(DailySalesMedicationFilterModel model);

        /// <summary>
        /// The patient pharmacy sales async.
        /// </summary>
        /// <param name="model"></param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<PharmacySaleBill>> FetchPatientPharmacyReportAsync(PharmacySaleBill model);

        /// <summary>
        /// The pharmacy purchase bills async.
        /// </summary>
        /// <param name="model"></param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<PharmacyPurchaseReportBill>> FetchPharmacyPurchaseReportAsync(PharmacyPurchaseReportBill model);

        /// <summary>
        /// The pharmacy purchase bills async.
        /// </summary>
        /// <param name="model"></param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<PharmacyPurchaseReportBill>> FetchProductPurchaseReportAsync(PharmacyPurchaseReportBill model);

        /// <summary>
        /// The pharmacy sale bills async.
        /// </summary>
        /// <param name="model"></param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<PharmacyPurchaseReportBill>> FetchProductSaleReportAsync(PharmacyPurchaseReportBill model);

        /// <summary>
        /// The patients async.
        /// </summary>
        /// <param name="model"></param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Report>> FetchDashboardInPatientsAsync(PatientFilterModel model);

        /// <summary>
        /// The patients async.
        /// </summary>
        /// <param name="model"></param>
        ///  <param>
        /// The provider Id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<OutReport>> FetchOutDashboardPatientsAsync(OutPatientFilterModel model);
        /// <summary>
        /// The patients async.
        /// </summary>
        /// <param name="model"></param>
        ///  <param>
        /// The provider Id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<PatientDashboardReport>> FetchFollowUpDashboardPatientsAsync(OutPatientFilterModel model);
        /// <summary>
        /// The patients async.
        /// </summary>
        /// <param name="model"></param>
        ///  <param>
        /// The provider Id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<PatientDashboardReport>> FetchWalkInDashboardPatientsAsync(OutPatientFilterModel model);
        /// <summary>
        /// The patients async.
        /// </summary>
        /// <param name="model"></param>
        ///  <param>
        /// The provider Id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<PatientDashboardReport>> FetchOnlineDashboardPatientsAsync(OutPatientFilterModel model);
        /// <summary>
        /// The patients async.
        /// </summary>
        /// <param name="model"></param>
        ///  <param>
        /// The provider Id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<PatientDashboardReport>> FetchNewPatientAppointmentDashboardPatientsAsync(OutPatientFilterModel model);
        /// <summary>
        /// The patients async.
        /// </summary>
        /// <param name="model"></param>
        ///  <param>
        /// The provider Id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<PatientDashboardReport>> FetchNewApointmentDashboardPatientsAsync(OutPatientFilterModel model);
        /// <summary>
        /// The patients async.
        /// </summary>
        /// <param name="model"></param>
        ///  <param>
        /// The provider Id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<PatientDashboardReport>> FetchOTApointmentDashboardPatientsAsync(OutPatientFilterModel model);

        /// <summary>
        /// <summary>
        /// The patients async.
        /// </summary>
        /// <param name="model">
        /// The search param.
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<OutReport>> OutPatientsAsync(OutPatientFilterModel model);

        /// <summary>
        /// The patients async.
        /// </summary>
        /// <param name="model">
        /// The search param.
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<ReceiptReportsModel>> FetchReceptionistReportsAsync(ReceiptReportsFilterModel model);

        /// <summary>
        /// The employee revenue async.
        /// </summary>
        /// <param name="model">
        /// The search param.
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<EmployeeRevenueReportsModel>> FetchEmployeeRevenueReportsAsync(EmployeeRevenueReportsFilterModel model);

        /// <summary>
        /// The patients async.
        /// </summary>
        /// <param name="model">
        /// The search param.
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<InventoryPurchaseBillReportsModel>> FetchInventoryPurchaseRegisterReportsAsync(InventoryPurchaseRegisteryFilterModel model);

        /// <summary>
        /// The patients async.
        /// </summary>
        /// <param name="model">
        /// The search param.
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<InventoryStockReportModel>> FetchInventoryStockReportsAsync(InventoryStockReportFilterModel model);

        /// <summary>
        /// The patients async.
        /// </summary>
        /// <param name="model">
        /// The search param.
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<IndentInventoryModel>> FetchIndentInventoryReportsAsync(IndentInventoryFilterModel model);

        /// <summary>
        /// The patients async.
        /// </summary>
        /// <param name="model">
        /// The search param.
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<PharmacyBillReportModel>> FetchPharmacyBillReportsAsync(IndentInventoryFilterModel model);
        /// <summary>
        /// The patients async.
        /// </summary>
        /// <param name="model">
        /// The search param.
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<PharmacyBillReportModel>> FetchPharamcyStockReportAsync(IndentInventoryFilterModel model);

        /// <summary>
        /// The fetch pharmacy stock report async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<PharmacyStockModel>> FetchPharmacyRetailStockReportAsync(PharmacyStockModel model);

        /// <summary>
        /// The fetch pharmacy stock report async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<PharmacyStockModel>> FetchPharmacyStockReportAsync(PharmacyStockModel model);

        /// <summary>
        /// The fetch doctor revenue report async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<EmployeeRevenueReportsModel>> FetchDoctorRevenueReportsAsync(EmployeeRevenueReportsFilterModel model);

        /// <summary>
        /// The fetch pharmacy indent issue report async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<PharmacyIndentHeaderModel>> FetchPharmacyIndentIssueReportsAsync(PharmacyIndentHeaderModel model);

        /// <summary>
        /// The fetch pharmacy indent issue report async.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IndentInventoryFilterModel> FetchFromDateAsync();

        /// <summary>
        /// The fetch pharmacy indent issue report async.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IndentInventoryFilterModel> FetchToDateAsync();

        /// <summary>
        /// The fetch pharmacy indent issue report async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
       // Task<IEnumerable<PharmacyProductProfit>> FetchProductProfitReportAsync(PharmacyProductProfit model);

        /// <summary>
        /// Fetches the patient registration count.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<RegistrationBillModel>> FetchPatientRegistrationCount(RegistrationBillModel model);

        /// <summary>
        /// The fetch doctor revenue report async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<EmployeeRevenueReportsModel>> FetchDoctorNewRevenueReportsAsync(EmployeeRevenueReportsFilterModel model);

        /// <summary>
        /// The fetch doctor revenue report async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<EmployeeRevenueReportsModel>> FetchEmployeeNewRevenueReportsAsync(EmployeeRevenueReportsFilterModel model);

        /// <summary>
        /// The fetch doctor revenue report async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<CancelAppointmentReport>> FetchCancelledAppointmentReportsAsync(OutPatientFilterModel model);

        /// <summary>
        /// The fetch doctor revenue report async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<CancelAppointmentReport>> FetchPatientAppointmentReportsAsync(OutPatientFilterModel model);

        /// <summary>
        /// The transaction async.
        /// </summary>
        /// <param name="model">
        /// The search param.
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<TransactionModel>> FetchTransactionReportsAsync(TransactionReportsFilterModel model);

        /// <summary>
        /// The patient pharmacy sales async.
        /// </summary>
        /// <param name="model"></param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<PatienSaleBill1>> FetchPatientPharmacyReportAndroidAsync(PatienSaleBill1 model);

        /// <summary>
        /// The patient pharmacy sales async.
        /// </summary>
        /// <param name="model"></param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<OutReport>> FetchNewPatientAsync(OutPatientFilterModel model);

        /// <summary>
        /// The employee wise  revenue collection in entire module.
        /// </summary>
        /// <param name="model"></param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>      
        Task<IEnumerable<ReceiptReportsModel>> FetchDetailEmployeeRevenueAsync(ReceiptReportsFilterModel model);
        /// <summary>
        /// The cancel-refund receipt in entire module report.
        /// </summary>
        /// <param name="model"></param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>      
        Task<IEnumerable<ReceiptReportsModel>> FetchCancelRefundReportAsync(ReceiptReportsFilterModel model);

        /// <summary>
        /// The outpatient wise gross collection.
        /// </summary>
        /// <param name="model"></param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>      
        Task<IEnumerable<GrossReportsModel>> FetchOPDailyGrossReportAsync(ReceiptReportsFilterModel model);
        /// <summary>
        /// The login user-wise collection.
        /// </summary>
        /// <param name="model"></param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>      
        Task<IEnumerable<ReceiptReportsModel>> FetchLoginUserCollectionReportAsync(ReceiptReportsFilterModel model);

        /// <summary>
        /// The bill daily report.
        /// </summary>
        /// <param name="model"></param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>      
        Task<IEnumerable<BillDailyReport>> FetchBillDailyReportAsync(ReceiptReportsFilterModel model);

        /// <summary>
        /// The login user-wise collection.
        /// </summary>
        /// <param name="model"></param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>      
        Task<IEnumerable<ReceiptReportsModel>> FetchUserCollectionReportAsync(ReceiptReportsFilterModel model);

        /// <summary>
        /// The schedule appointment with doctor.
        /// </summary>
        /// <param name="model"></param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>      
        Task<IEnumerable<ReceiptReportsModel>> FetchScheduleAppointmentReportAsync(ReceiptReportsFilterModel model);
        /// <summary>
        /// The patients async.
        /// </summary>
        /// <param name="model"></param>
        ///  <param>
        /// The provider Id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<PatientDashboardReport>> FetchAllAppointments(OutPatientFilterModel model);
        /// <summary>
        /// The patients async.
        /// </summary>
        /// <param name="model"></param>
        ///  <param>
        /// The provider Id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<PatientDashboardReport>> FetchRemindersAsync(OutPatientFilterModel model);

        /// <summary>
        /// The patients async.
        /// </summary>
        /// <param name="model"></param>
        ///  <param>
        /// The provider Id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<PatientDashboardReport>> FetchAllAdmission(OutPatientFilterModel model);
        /// <summary>
        /// The patients async.
        /// </summary>
        /// <param name="model"></param>
        ///  <param>
        /// The provider Id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<AdmissionReportModel> FetchAdmissionFormReportAsync(PatientFilterModel model);


        /// <summary>
        /// The schedule appointment with scan machine.
        /// </summary>
        /// <param name="model"></param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>      
        Task<IEnumerable<FetchBookScanAppointment>> FetchScheduleScanReportAsync(ReceiptReportsFilterModel model);

        /// <summary>
        /// The schedule appointment with scan machine.
        /// </summary>
        /// <param name="model"></param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>      
        Task<IEnumerable<MisReportFetchModel>> FetchMISReportAsync(FilterModel model);

        /// <summary>
        /// The schedule appointment with scan machine.
        /// </summary>
        /// <param name="model"></param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns> 
        Task<IEnumerable<DoctorDetailReportModel>> FetchNewDoctorDetailRevenueReportAsync(ReceiptReportsFilterModel model);
        /// <summary>
        /// The schedule appointment with scan machine.
        /// </summary>
        /// <param name="model"></param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns> 
        Task<IEnumerable<LabBookingModel>> FetchLabDetailReports(LabBookingModel model);


        Task<IEnumerable<PharmacyRetailStockReportModel>> FetchExpiredStockAsync(PharmacyRetailStockReportModel model);



        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        Task<IEnumerable<LabTATNewReportModel>> FetchLabNewTATReportAsync(LabTATNewReportModel model);
        Task<IEnumerable<AdmissionDepartmentModel>> FetchAdmissionDepartmentAsync();
        Task<IEnumerable<EmployeeRevenueReportsModel>> FetchConsultationCountAsync(EmployeeRevenueReportsFilterModel model);
        /// <summary>
        /// The schedule appointment with scan machine.
        /// </summary>
        /// <param name="model"></param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns> 
        Task<IEnumerable<MedicationCountModel>> FetchProductSaleCountReport(MedicineRankFilterModel model);

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        Task<IEnumerable<LabMothlyCountModel>> FetchLabMonthlyCountReportAsync(LabMothlyCountModel model);

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        Task<IEnumerable<ConsultantWiseRevenueModel>> ConsultantWiseRevenue(ConsultantWiseRevenueModel model);
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        Task<IEnumerable<BillDiscountModel>> FetchBillDiscountAsync(BillDiscountModel model);

        Task<IEnumerable<AdmissionCountsFilterModel>> FetchAdmissionCountDeptWiseAsync(AdmissionCountsFilterModel model);

        Task FetchLabNewTATReportAsync();

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        Task<IEnumerable<RetailIndentIssueModel>> FetchRetailIndentIssue(RetailIndentIssueModel model);

        Task<IEnumerable<AdmissionCountsFilterModel>> FetchAvarageStayWardWiseReportAsync(AdmissionCountsFilterModel model);
        Task<IEnumerable<Call_HistoryModel>> CallHistoryAsync(Call_HistoryModel model);
    }
}