﻿namespace Hims.Infrastructure.Services
{
    using System;
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Dapper;
    using Domain.Entities;
    using Domain.Repositories.UnitOfWork;
    using Domain.Services;
    using Shared.EntityModels;

    using Hims.Shared.UserModels;

    /// <inheritdoc />
    public class GeneralNotificationServices : IGeneralNotificationService
    {
        /// <summary>
        /// The unit of work.
        /// </summary>
        private readonly IUnitOfWork unitOfWork;

        /// <inheritdoc cref="IGeneralNotificationService" />
        public GeneralNotificationServices(IUnitOfWork unitOfWork) => this.unitOfWork = unitOfWork;


        /// <inheritdoc />
        public async Task<int> AddGeneralNotificationAsync(GeneralNotificationModel generalNotification)
        {
            var model = new GeneralNotification
            {
                CreatedBy = generalNotification.CreatedBy,
                CreatedDate = generalNotification.CreatedDate,
                ForAccounts = generalNotification.ForAccounts,
                ForRoles = generalNotification.ForRoles,
                IsPriority = generalNotification.IsPriority,
                IsRead = false,
                Message = generalNotification.Message,
                ModulesMasterId = generalNotification.ModulesMasterId,
                RedirectUrl = generalNotification.RedirectUrl,
                ReferenceId = generalNotification.ReferenceId,
                WebNotificationLogTypeId = generalNotification.WebNotificationLogTypeId,
            };

            return await this.unitOfWork.GeneralNotifications.InsertAsync(model);
        }
    }
}