﻿namespace Hims.Shared.Dapper.SqlGenerator
{
    using System.Reflection;

    using Attributes.Joins;

    /// <inheritdoc />
    public class SqlJoinPropertyMetadata : SqlPropertyMetadata
    {
        /// <inheritdoc />
        public SqlJoinPropertyMetadata(PropertyInfo joinPropertyInfo, PropertyInfo propertyInfo) : base(propertyInfo)
        {
            var joinAttribute = joinPropertyInfo.GetCustomAttribute<JoinAttributeBase>();
            this.JoinPropertyInfo = joinPropertyInfo;
            this.TableSchema = joinAttribute?.TableSchema;
            this.TableName = joinAttribute?.TableName;
            this.TableAlias = joinAttribute?.TableAlias;
        }

        /// <summary>
        /// Gets or sets the table name.
        /// </summary>
        public string TableName { get; set; }

        /// <summary>
        /// Gets or sets the table alias.
        /// </summary>
        public string TableAlias { get; set; }

        /// <summary>
        /// Gets or sets the table schema.
        /// </summary>
        public string TableSchema { get; set; }

        /// <summary>
        /// Gets or sets the join property info.
        /// </summary>
        public PropertyInfo JoinPropertyInfo { get; set; }

        /// <summary>
        /// The join property name.
        /// </summary>
        public string JoinPropertyName => this.JoinPropertyInfo.Name;

        /// <inheritdoc />
        /// <summary>
        /// The property name.
        /// </summary>
        public override string PropertyName => this.JoinPropertyName + base.PropertyName;
    }
}