﻿namespace Hims.Shared.DataFilters
{
    using System.Linq;

    /// <summary>
    /// The empty filter.
    /// </summary>
    public static class EmptyFilter
    {
        /// <summary>
        /// The decrypt.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The  model<see />.
        /// </returns>
        public static object Handler(object model)
        {
          var properties = model.GetType().GetProperties().Where(m => m.PropertyType == typeof(string));
            foreach (var item in properties)
            {
                var value = (string)item.GetValue(model);
                if (value == string.Empty || value == "null")
                {
                    item.SetValue(model, null);
                }
            }

            return model;
        }
    }
}