﻿#nullable enable
namespace Hims.Shared.UserModels.Filters
{
    using Library.Enums;

    /// <summary>
    /// The encounter filter model.
    /// </summary>
    public class BehavioralFilterModel
    {
        /// <summary>
        /// Gets or sets the encounter id.
        /// </summary>
        public int BehavioralHealthId { get; set; }

        /// <summary>
        /// Gets or sets the appointment id.
        /// </summary>
        public int AppointmentId { get; set; }

        /// <summary>
        /// Gets or sets the encrypted encounter id.
        /// </summary>
        public string? EncryptedBehavioralHealthId { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the encrypted appointment id.
        /// </summary>
        public string? EncryptedAppointmentId { get; set; }

        /// <summary>
        /// Gets or sets the encrypted appointment id.
        /// </summary>
        public string? EncryptedPatientId { get; set; }

        /// <summary>
        /// Gets or sets the encrypted provider id.
        /// </summary>
        public string? EncryptedProviderId { get; set; }

        /// <summary>
        /// Gets or sets the type.
        /// </summary>
        public BehavioralHealthType Type { get; set; }


        /// <summary>
        /// Gets or sets the appointment no.
        /// </summary>
        public string AppointmentNo { get; set; }
    }
}
