﻿using System;
using System.Collections.Generic;

namespace Hims.Shared.UserModels.Vendors
{
    /// <summary>
    /// The incoming quotation header model.
    /// </summary>
    public class IncomingQuotationHeaderModel
    {
        /// <summary>
        /// Gets or sets the incoming quotation header identifier.
        /// </summary>
        /// <value>
        /// The incoming quotation header identifier.
        /// </value>
        public long IncomingQuotationHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the product for quotation header identifier.
        /// </summary>
        /// <value>
        /// The product for quotation header identifier.
        /// </value>
        public long ProductForQuotationHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the supplier identifier.
        /// </summary>
        /// <value>
        /// The supplier identifier.
        /// </value>
        public int SupplierId { get; set; }

        /// <summary>
        /// Gets or sets the payment due days.
        /// </summary>
        /// <value>
        /// The payment due days.
        /// </value>
        public int? PaymentDueDays { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        /// <value>
        /// The modified by.
        /// </value>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        /// <value>
        /// The modified date.
        /// </value>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is finalized.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is finalized; otherwise, <c>false</c>.
        /// </value>
        public bool IsFinalized { get; set; }

        /// <summary>
        /// Gets or sets the finalized by.
        /// </summary>
        /// <value>
        /// The finalized by.
        /// </value>
        public int? FinalizedBy { get; set; }

        /// <summary>
        /// Gets or sets the finalized date.
        /// </summary>
        /// <value>
        /// The finalized date.
        /// </value>
        public DateTime? FinalizedDate { get; set; }

        /// <summary>
        /// Gets or sets the delivery date.
        /// </summary>
        /// <value>
        /// The delivery date.
        /// </value>
        public DateTime? DeliveryDate { get; set; }

        /// <summary>
        /// Gets or sets the total amount.
        /// </summary>
        /// <value>
        /// The total amount.
        /// </value>
        public double TotalAmount { get; set; }

        /// <summary>
        /// Gets or sets the total tax.
        /// </summary>
        /// <value>
        /// The total tax.
        /// </value>
        public double TotalTax { get; set; }

        /// <summary>
        /// Gets or sets the total net amount.
        /// </summary>
        /// <value>
        /// The total net amount.
        /// </value>
        public double TotalNetAmount { get; set; }

        /// <summary>
        /// Gets or sets the total discount.
        /// </summary>
        /// <value>
        /// The total discount.
        /// </value>
        public double TotalDiscount { get; set; }

        /// <summary>
        /// Gets or sets the products.
        /// </summary>
        /// <value>
        /// The products.
        /// </value>
        public List<IncomingQuotationDetailModel> Products { get; set; }

        /// <summary>
        /// Gets or sets the name of the supplier.
        /// </summary>
        /// <value>
        /// The name of the supplier.
        /// </value>
        public string SupplierName { get; set; }

        /// <summary>
        /// Gets or sets the name of the created by.
        /// </summary>
        /// <value>
        /// The name of the created by.
        /// </value>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the name of the modified by.
        /// </summary>
        /// <value>
        /// The name of the modified by.
        /// </value>
        public string ModifiedByName { get; set; }

        /// <summary>
        /// Gets or sets the name of the finalized by.
        /// </summary>
        /// <value>
        /// The name of the finalized by.
        /// </value>
        public string FinalizedByName { get; set; }
    }

    /// <summary>
    /// The incoming quotation detail model.
    /// </summary>
    public class IncomingQuotationDetailModel
    {
        /// <summary>
        /// Gets or sets the incoming quotation detail identifier.
        /// </summary>
        /// <value>
        /// The incoming quotation detail identifier.
        /// </value>
        public long IncomingQuotationDetailId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy product approval identifier.
        /// </summary>
        /// <value>
        /// The pharmacy product approval identifier.
        /// </value>
        public long PharmacyProductApprovalId { get; set; }

        /// <summary>
        /// Gets or sets the incoming quotation header identifier.
        /// </summary>
        /// <value>
        /// The incoming quotation header identifier.
        /// </value>
        public long IncomingQuotationHeaderId { get; set; }
        /// <summary>
        /// Gets or sets the product for quotation detail identifier.
        /// </summary>
        /// <value>
        /// The product for quotation detail identifier.
        /// </value>
        public long ProductForQuotationDetailId { get; set; }
        /// <summary>
        /// Gets or sets the pharmacy product identifier.
        /// </summary>
        /// <value>
        /// The pharmacy product identifier.
        /// </value>
        public int PharmacyProductId { get; set; }
        /// <summary>
        /// Gets or sets the tax.
        /// </summary>
        /// <value>
        /// The tax.
        /// </value>
        public int Tax { get; set; }
        /// <summary>
        /// Gets or sets the purchase rate.
        /// </summary>
        /// <value>
        /// The purchase rate.
        /// </value>
        public double PurchaseRate { get; set; }
        /// <summary>
        /// Gets or sets the MRP.
        /// </summary>
        /// <value>
        /// The MRP.
        /// </value>
        public double MRP { get; set; }
        /// <summary>
        /// Gets or sets the amount.
        /// </summary>
        /// <value>
        /// The amount.
        /// </value>
        public double Amount { get; set; }
        /// <summary>
        /// Gets or sets the tax amount.
        /// </summary>
        /// <value>
        /// The tax amount.
        /// </value>
        public double TaxAmount { get; set; }
        /// <summary>
        /// Gets or sets the discount percentage.
        /// </summary>
        /// <value>
        /// The discount percentage.
        /// </value>
        public double DiscountPercentage { get; set; }
        /// <summary>
        /// Gets or sets the discount amount.
        /// </summary>
        /// <value>
        /// The discount amount.
        /// </value>
        public double DiscountAmount { get; set; }
        /// <summary>
        /// Gets or sets the net amount.
        /// </summary>
        /// <value>
        /// The net amount.
        /// </value>
        public double NetAmount { get; set; }
        /// <summary>
        /// Gets or sets the quantity.
        /// </summary>
        /// <value>
        /// The quantity.
        /// </value>
        public int Quantity { get; set; }
        /// <summary>
        /// Gets or sets the free.
        /// </summary>
        /// <value>
        /// The free.
        /// </value>
        public int? Free { get; set; }

        /// <summary>
        /// Gets or sets the name of the product.
        /// </summary>
        /// <value>
        /// The name of the product.
        /// </value>
        public string ProductName { get; set; }

        /// <summary>
        /// Gets or sets the name of the generic.
        /// </summary>
        /// <value>
        /// The name of the generic.
        /// </value>
        public string GenericName { get; set; }

        /// <summary>
        /// Gets or sets the name of the company.
        /// </summary>
        /// <value>
        /// The name of the company.
        /// </value>
        public string CompanyName { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether [inventory item].
        /// </summary>
        /// <value>
        ///   <c>true</c> if [inventory item]; otherwise, <c>false</c>.
        /// </value>
        public bool InventoryItem { get; set; }
    }
}
