﻿namespace Hims.Domain.Entities.Labs
{
    using Hims.Shared.Dapper.Attributes;
    using System;
    using System.ComponentModel.DataAnnotations;

    /// <summary>
    /// The new lab booking detail.
    /// </summary>
    public class NewLabBookingDetail
    {
        /// <summary>
        /// Creates new labbookingdetailid.
        /// </summary>
        /// <value>
        /// The new lab booking detail identifier.
        /// </value>
        [Key, Identity]
        public int NewLabBookingDetailId { get; set; }

        /// <summary>
        /// Creates new labbookingheaderid.
        /// </summary>
        /// <value>
        /// The new lab booking header identifier.
        /// </value>
        public int NewLabBookingHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the lab main detail identifier.
        /// </summary>
        /// <value>
        /// The lab main detail identifier.
        /// </value>
        public int LabMainDetailId { get; set; }

        /// <summary>
        /// Gets or sets the charge category identifier.
        /// </summary>
        /// <value>
        /// The charge category identifier.
        /// </value>
        public int ChargeCategoryId { get; set; }

        /// <summary>
        /// Gets or sets the lab booking status identifier.
        /// </summary>
        /// <value>
        /// The lab booking status identifier.
        /// </value>
        public int LabBookingStatusId { get; set; }

        /// <summary>
        /// Gets or sets the discount percentage.
        /// </summary>
        /// <value>
        /// The discount percentage.
        /// </value>
        public double? DiscountPercentage { get; set; }

        /// <summary>
        /// Gets or sets the discount amount.
        /// </summary>
        /// <value>
        /// The discount amount.
        /// </value>
        public double? DiscountAmount { get; set; }

        /// <summary>
        /// Gets or sets the total amount.
        /// </summary>
        /// <value>
        /// The total amount.
        /// </value>
        public double TotalAmount { get; set; }

        /// <summary>
        /// Gets or sets the net amount.
        /// </summary>
        /// <value>
        /// The net amount.
        /// </value>
        public double NetAmount { get; set; }

        /// <summary>
        /// Gets or sets the lab service identifier.
        /// </summary>
        /// <value>
        /// The lab service identifier.
        /// </value>
        public int? LabServicesId { get; set; }

        /// <summary>
        /// Gets or sets the report URL.
        /// </summary>
        /// <value>
        /// The report URL.
        /// </value>
        public string ReportUrl { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether [external lab].
        /// </summary>
        /// <value>
        ///   <c>true</c> if [external lab]; otherwise, <c>false</c>.
        /// </value>
        public bool ExternalLab { get; set; }


        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int? UploadedBy { get; set; }

        /// <summary>
        /// Gets or sets the uploaded date.
        /// </summary>
        /// <value>
        /// The uploaded date.
        /// </value>
        public DateTime? UploadedDate { get; set; }

        /// <summary>
        /// Gets or sets the comment.
        /// </summary>
        /// <value>
        /// The comment.
        /// </value>
        public string Comment { get; set; }

        /// <summary>
        /// Gets or sets the hold by.
        /// </summary>
        /// <value>
        /// The hold by.
        /// </value>
        public int? HoldBy { get; set; }

        /// <summary>
        /// Gets or sets the un hold by.
        /// </summary>
        /// <value>
        /// The un hold by.
        /// </value>
        public int? UnHoldBy { get; set; }

        /// <summary>
        /// Gets or sets the hold comments.
        /// </summary>
        /// <value>
        /// The hold comments.
        /// </value>
        public string HoldComments { get; set; }


        /// <summary>
        /// Gets or sets the un hold comments.
        /// </summary>
        /// <value>
        /// The un hold comments.
        /// </value>
        public string UnHoldComments { get; set; }

        /// <summary>
        /// Gets or sets the emergency.
        /// </summary>
        /// <value>
        /// The emergency.
        /// </value>
        public bool? Emergency { get; set; }

        /// <summary>
        /// Gets or sets the technician identifier.
        /// </summary>
        /// <value>
        /// The technician identifier.
        /// </value>
        public int? TechnicianId { get; set; }

        /// <summary>
        /// Gets or sets the technician comment.
        /// </summary>
        /// <value>
        /// The technician comment.
        /// </value>
        public string TechnicianComment { get; set; }

        /// <summary>
        /// Gets or sets the technician verification date.
        /// </summary>
        /// <value>
        /// The technician verification date.
        /// </value>
        public DateTime? TechnicianVerificationDate { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether [home sample].
        /// </summary>
        /// <value>
        ///   <c>true</c> if [home sample]; otherwise, <c>false</c>.
        /// </value>
        public bool? HomeSample { get; set; }
    }
}
