﻿namespace Hims.Domain.Entities.Vendors
{
    using System.ComponentModel.DataAnnotations;
    using System.ComponentModel.DataAnnotations.Schema;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The incoming quoatation detail.
    /// </summary>
    [Table("IncomingQuotationDetail", Schema = "vendors")]
    public class IncomingQuotationDetail
    {
        /// <summary>
        /// Gets or sets the incoming quotation detail identifier.
        /// </summary>
        /// <value>
        /// The incoming quotation detail identifier.
        /// </value>
        [Key, Identity]
        public long IncomingQuotationDetailId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy product approval identifier.
        /// </summary>
        /// <value>
        /// The pharmacy product approval identifier.
        /// </value>
        public long PharmacyProductApprovalId { get; set; }

        /// <summary>
        /// Gets or sets the incoming quotation header identifier.
        /// </summary>
        /// <value>
        /// The incoming quotation header identifier.
        /// </value>
        public long IncomingQuotationHeaderId { get; set; }
        /// <summary>
        /// Gets or sets the product for quotation detail identifier.
        /// </summary>
        /// <value>
        /// The product for quotation detail identifier.
        /// </value>
        public long ProductForQuotationDetailId { get; set; }
        /// <summary>
        /// Gets or sets the pharmacy product identifier.
        /// </summary>
        /// <value>
        /// The pharmacy product identifier.
        /// </value>
        public int PharmacyProductId { get; set; }
        /// <summary>
        /// Gets or sets the tax.
        /// </summary>
        /// <value>
        /// The tax.
        /// </value>
        public int Tax { get; set; }
        /// <summary>
        /// Gets or sets the purchase rate.
        /// </summary>
        /// <value>
        /// The purchase rate.
        /// </value>
        public double PurchaseRate { get; set; }
        /// <summary>
        /// Gets or sets the MRP.
        /// </summary>
        /// <value>
        /// The MRP.
        /// </value>
        public double MRP { get; set; }
        /// <summary>
        /// Gets or sets the amount.
        /// </summary>
        /// <value>
        /// The amount.
        /// </value>
        public double Amount { get; set; }
        /// <summary>
        /// Gets or sets the tax amount.
        /// </summary>
        /// <value>
        /// The tax amount.
        /// </value>
        public double TaxAmount { get; set; }
        /// <summary>
        /// Gets or sets the discount percentage.
        /// </summary>
        /// <value>
        /// The discount percentage.
        /// </value>
        public double DiscountPercentage { get; set; }
        /// <summary>
        /// Gets or sets the discount amount.
        /// </summary>
        /// <value>
        /// The discount amount.
        /// </value>
        public double DiscountAmount { get; set; }
        /// <summary>
        /// Gets or sets the net amount.
        /// </summary>
        /// <value>
        /// The net amount.
        /// </value>
        public double NetAmount { get; set; }
        /// <summary>
        /// Gets or sets the quantity.
        /// </summary>
        /// <value>
        /// The quantity.
        /// </value>
        public int Quantity { get; set; }
        /// <summary>
        /// Gets or sets the free.
        /// </summary>
        /// <value>
        /// The free.
        /// </value>
        public int? Free { get; set; }
    }
}
