﻿namespace Hims.Shared.EntityModels
{
    using Hims.Shared.Dapper.Attributes;
    using System;
    using System.ComponentModel.DataAnnotations;

    /// <summary>
    /// The health card model.
    /// </summary>
    public class HealthCardModel
    {
        /// <summary>
        /// Gets or sets the health card id.
        /// </summary>
        public int HealthCardId { get; set; }

        /// <summary>
        /// Gets or sets the health card name.
        /// </summary>
        public string HealthCardName { get; set; }

        /// <summary>
        /// Gets or sets the amount.
        /// </summary>
        public double? Amount { get; set; }

        /// <summary>
        /// Gets or sets the allow members.
        /// </summary>
        public int AllowMembers { get; set; }

        /// <summary>
        /// Gets or sets the validity Type.
        /// </summary>
        public string ValidityType { get; set; }
        /// <summary>
        /// Gets or sets the duration.
        /// </summary>
        public int Duration { get; set; }
        /// <summary>
        /// Gets or sets the active.
        /// </summary>
        public bool? Active { get; set; }
        /// <summary>
        /// Gets or sets the created by.
        /// </summary>

        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        public int? TotalItems { get; set; }
        /// <summary>
        /// Gets or sets the page index.
        /// </summary>
        public int? PageIndex { get; set; }
        /// <summary>
        /// Gets or sets the page size.
        /// </summary>
        public int? PageSize { get; set; }
        /// <summary>
        /// Gets or sets the created by name.
        /// </summary>
        public string CreatedByName { get; set; }
        /// <summary>
        /// Gets or sets the modified by name.
        /// </summary>
        public string ModifiedByName { get; set; }
    }
}
