﻿namespace Hims.Shared.EntityModels
{
    using System.Collections.Generic;
    using System.Diagnostics.CodeAnalysis;

    /// <summary>
    /// The notification device model.
    /// </summary>
    public class NotificationDeviceModel
    {
        /// <summary>
        /// Gets or sets the encrypted encounter id.
        /// </summary>
        public string DeviceToken { get; set; }
    
        /// <summary>
        /// Gets or sets the encrypted encounter id.
        /// </summary>
        public short DeviceType { get; set; }
    }

    /// <summary>
    /// The Video Call Push Notification.
    /// </summary>
    [SuppressMessage("StyleCop.CSharp.MaintainabilityRules", "SA1402:FileMayOnlyContainASingleClass", Justification = "Reviewed. Suppression is OK here.")]
    public class NotificationIntimateModel
    {
        /// <summary>
        /// Gets or sets the devices.
        /// </summary>
        public List<NotificationDeviceModel> Devices { get; set; }

        /// <summary>
        ///  Gets or sets the message.
        /// </summary>
        public string Message { get; set; }

        /// <summary>
        ///  Gets or sets the message.
        /// </summary>
        public string Type { get; set; }

        /// <summary>
        ///  Gets or sets the message.
        /// </summary>
        public string RoomName { get; set; }

        /// <summary>
        ///  Gets or sets the message.
        /// </summary>
        public string OriginalRoomName { get; set; }

        /// <summary>
        /// Gets or sets the domain name.
        /// </summary>
        public string DomainName { get; set; }

        /// <summary>
        ///  Gets or sets the message.
        /// </summary>
        public int CallerId { get; set; }

        /// <summary>
        ///  Gets or sets the message.
        /// </summary>
        public int TelemedicineId { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether is call.
        /// </summary>
        public bool IsCall { get; set; }

        /// <summary>
        /// Gets or sets the title.
        /// </summary>
        public string Title { get; set; }

        /// <summary>
        /// Gets or sets the sub title.
        /// </summary>
        public string SubTitle { get; set; }
        public int AccountId { get; set; }
        public bool StartAudioOnly { get; set; }
    }
}