﻿#nullable enable
namespace Hims.Shared.EntityModels
{
    using System;

    /// <summary>
    /// The ticket model.
    /// </summary>
    public class TicketModel
    {
        /// <summary>
        /// Gets or sets the ticket id.
        /// </summary>
        public long TicketId { get; set; }

        /// <summary>
        /// Gets or sets the encrypted ticked id.
        /// </summary>
        public string? EncryptedTickedId { get; set; }

        /// <summary>
        /// Gets or sets the ticket number.
        /// </summary>
        public string? TicketNumber { get; set; }

        /// <summary>
        /// Gets or sets the country id.
        /// </summary>
        public int CountryId { get; set; }

        /// <summary>
        /// Gets or sets the priority.
        /// </summary>
        public string? Priority { get; set; }

        /// <summary>
        /// Gets or sets the support category id.
        /// </summary>
        public int SupportCategoryId { get; set; }

        /// <summary>
        /// Gets or sets the location id.
        /// </summary>
        public int? LocationId { get; set; }

        /// <summary>
        /// Gets or sets the assigned to.
        /// </summary>
        public int? AssignedTo { get; set; }

        /// <summary>
        /// Gets or sets the description.
        /// </summary>
        public string? Description { get; set; }

        /// <summary>
        /// Gets or sets the attachment.
        /// </summary>
        public string? Attachment { get; set; }

        /// <summary>
        /// Gets or sets the role name.
        /// </summary>
        public string? RoleName { get; set; }

        /// <summary>
        /// Gets or sets the support conversation.
        /// </summary>
        public string? SupportConversation { get; set; }

        /// <summary>
        /// Gets or sets the raised by.
        /// </summary>
        public int? RaisedBy { get; set; }

        /// <summary>
        /// Gets or sets the mobile.
        /// </summary>
        public string? Mobile { get; set; }

        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        public string? Status { get; set; }

        /// <summary>
        /// Gets or sets the from when.
        /// </summary>
        public string? FromWhen { get; set; }

        /// <summary>
        /// Gets or sets the issue with.
        /// </summary>
        public string? IssueWith { get; set; }

        /// <summary>
        /// Gets or sets the raised by name.
        /// </summary>
        public string? RaisedByName { get; set; }

        /// <summary>
        /// Gets or sets the assigned to name.
        /// </summary>
        public string? AssignedToName { get; set; }

        /// <summary>
        /// Gets or sets the comments.
        /// </summary>
        public string? Comments { get; set; }

        /// <summary>
        /// Gets or sets the thumbnail url.
        /// </summary>
        public string? ThumbnailUrl { get; set; }

        /// <summary>
        /// Gets or sets the start date.
        /// </summary>
        public DateTime StartDate { get; set; }

        /// <summary>
        /// Gets or sets the end date.
        /// </summary>
        public DateTime? EndDate { get; set; }

        /// <summary>
        /// Gets or sets the due date.
        /// </summary>
        public DateTime? DueDate { get; set; }

        /// <summary>
        /// Gets or sets the due time.
        /// </summary>
        public TimeSpan? DueTime { get; set; }

        /// <summary>
        /// Gets or sets the due date time.
        /// </summary>
        public string? DueDateTime { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int? CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        public int TotalItems { get; set; }

        /// <summary>
        /// Gets or sets the hours.
        /// </summary>
        public string? Hours { get; set; }

        /// <summary>
        /// Gets or sets the hour comment.
        /// </summary>
        public string? HourComment { get; set; }

        /// <summary>
        /// Gets or sets the owner name.
        /// </summary>
        public string? OwnerName { get; set; }

        /// <summary>
        /// Gets or sets the device type.
        /// </summary>
        public string? DeviceType { get; set; } = string.Empty;
    }
}
