﻿#nullable enable
namespace Hims.Shared.UserModels.Filters
{
    /// <summary>
    /// The provider availability filter model.
    /// </summary>
    public class ProviderAvailabilityFilterModel
    {
        /// <summary>
        /// Gets or sets the provider id.
        /// </summary>
        public int ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the provider location id.
        /// </summary>
        public int? ProviderAvailabilityId { get; set; }

        /// <summary>
        /// Gets or sets the provider location id.
        /// </summary>
        public int? ProviderLocationId { get; set; }

        /// <summary>
        /// Gets or sets the specialization id.
        /// </summary>
        public int? SpecializationId { get; set; }

        /// <summary>
        /// Gets or sets the from date.
        /// </summary>
        public string FromDate { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the to date.
        /// </summary>
        public string ToDate { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the encrypted provider id.
        /// </summary>
        public string? EncryptedProviderId { get; set; }

        /// <summary>
        /// Gets or sets the location identifier.
        /// </summary>
        /// <value>
        /// The location identifier.
        /// </value>
        public int? LocationId { get;set;}

        /// <summary>
        /// Gets or sets the start date.
        /// </summary>
        public string? StartDate { get; set; }

        /// <summary>
        /// Gets or sets the end date.
        /// </summary>
        public string? EndDate { get; set; }

        /// <summary>
        /// Gets or sets the specialization id.
        /// </summary>
        public int? ConsultationTypeId { get; set; }
    }
}
