﻿namespace Hims.Shared.UserModels.Laboratory
{
    using System;

    /// <summary>
    /// The lab package detail model.
    /// </summary>
    public class LabPackageDetailModel
    {
        /// <summary>
        /// Gets or sets the lab package detail id.
        /// </summary>
        public int LabPackageDetailId { get; set; }

        /// <summary>
        /// Gets or sets the lab package id.
        /// </summary>
        public int LabPackageId { get; set; }

        /// <summary>
        /// Gets or sets the lab header id.
        /// </summary>
        public int LabHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the lab name.
        /// </summary>
        public string LabName { get; set; }

        /// <summary>
        /// Gets or sets the lab code.
        /// </summary>
        public string LabCode { get; set; }

        /// <summary>
        /// Gets or sets the created by name.
        /// </summary>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the signature.
        /// </summary>
        public string Signature { get; set; }

        /// <summary>
        /// Gets or sets the charge.
        /// </summary>
        public double Charge { get; set; }

        /// <summary>
        /// Gets or sets the in patient charge.
        /// </summary>
        public double InPatientCharge { get; set; }

        /// <summary>
        /// Gets or sets the active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets total items.
        /// </summary>
        public int TotalItems { get; set; }

        /// <summary>
        /// Gets or sets the discount percentage.
        /// </summary>
        public int? DiscountPercentage { get; set; }

        /// <summary>
        /// Gets or sets the discount amount.
        /// </summary>
        public double? DiscountAmount { get; set; }

        /// <summary>
        /// Gets or sets the net amount.
        /// </summary>
        public double NetAmount { get; set; }
    }
}
