﻿namespace Hims.Shared.UserModels.Labs
{
    using System;
    using System.Collections.Generic;
    using UserModels.ChargeModule;

    /// <summary>
    /// The lab sample type model.
    /// </summary>
    public class LabSampleTypeModel
    {
        /// <summary>
        /// Gets or sets the lab sample type identifier.
        /// </summary>
        /// <value>
        /// The lab sample type identifier.
        /// </value>
        public int LabSampleTypeId { get; set; }

        /// <summary>
        /// Gets or sets the name of the type.
        /// </summary>
        /// <value>
        /// The name of the type.
        /// </value>
        public string TypeName { get; set; }
    }

    /// <summary>
    /// The lab main detail model.
    /// </summary>
    public class LabMainDetailModel
    {
        /// <summary>
        /// Gets or sets the lab main detail identifier.
        /// </summary>
        /// <value>
        /// The lab main detail identifier.
        /// </value>
        public int LabMainDetailId { get; set; }

        /// <summary>
        /// Gets or sets the name of the test.
        /// </summary>
        /// <value>
        /// The name of the test.
        /// </value>
        public string TestName { get; set; }

        /// <summary>
        /// Gets or sets the test code.
        /// </summary>
        /// <value>
        /// The test code.
        /// </value>
        public string TestCode { get; set; }

        /// <summary>
        /// Gets or sets the lab department identifier.
        /// </summary>
        /// <value>
        /// The lab department identifier.
        /// </value>
        public int LabDepartmentId { get; set; }

        /// <summary>
        /// Gets or sets the lab sample type identifier.
        /// </summary>
        /// <value>
        /// The lab sample type identifier.
        /// </value>
        public int? LabSampleTypeId { get; set; }

        /// <summary>
        /// Gets or sets the charge exist for current location.
        /// </summary>
        /// <value>
        /// The charge exist for current location.
        /// </value>
        public int? ChargeExistForCurrentLocation { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this <see cref="LabMainDetailModel"/> is active.
        /// </summary>
        /// <value>
        ///   <c>true</c> if active; otherwise, <c>false</c>.
        /// </value>
        public bool? Active { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is internal lab.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is internal lab; otherwise, <c>false</c>.
        /// </value>
        public bool IsInternalLab { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is external lab.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is external lab; otherwise, <c>false</c>.
        /// </value>
        public bool IsExternalLab { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int? CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        /// <value>
        /// The modified by.
        /// </value>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        /// <value>
        /// The modified date.
        /// </value>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the name of the department.
        /// </summary>
        /// <value>
        /// The name of the department.
        /// </value>
        public string DepartmentName { get; set; }

        /// <summary>
        /// Gets or sets the name of the type.
        /// </summary>
        /// <value>
        /// The name of the type.
        /// </value>
        public string TypeName { get; set; }

        /// <summary>
        /// Gets or sets the name of the created by.
        /// </summary>
        /// <value>
        /// The name of the created by.
        /// </value>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the name of the modified by.
        /// </summary>
        /// <value>
        /// The name of the modified by.
        /// </value>
        public string ModifiedByName { get; set; }

        /// <summary>
        /// Gets or sets the templates.
        /// </summary>
        /// <value>
        /// The templates.
        /// </value>
        public List<LabMainDetailTemplateModel> Templates { get; set; }

        ///// <summary>
        ///// Gets or sets the charges.
        ///// </summary>
        ///// <value>
        ///// The charges.
        ///// </value>
        ////public List<LabMainDetailChargeModel> Charges { get; set; }

        public List<ChargeModuleDetailsModel> Charges { get; set; }

        /// <summary>
        /// Gets or sets the location identifier.
        /// </summary>
        /// <value>
        /// The location identifier.
        /// </value>
        public int? LocationId { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        /// <value>
        /// The total items.
        /// </value>
        public int TotalItems { get; set; }

        /// <summary>
        /// Gets or sets the size of the page.
        /// </summary>
        /// <value>
        /// The size of the page.
        /// </value>
        public int? PageSize { get; set; }

        /// <summary>
        /// Gets or sets the index of the page.
        /// </summary>
        /// <value>
        /// The index of the page.
        /// </value>
        public int? PageIndex { get; set; }

        /// <summary>
        /// Gets or sets the term.
        /// </summary>
        /// <value>
        /// The term.
        /// </value>
        public string Term { get; set; }

        /// <summary>
        /// Gets or sets the joined.
        /// </summary>
        /// <value>
        /// The joined.
        /// </value>
        public string Joined { get; set; }

        /// <summary>
        /// Gets or sets the patient lab detail identifier.
        /// </summary>
        /// <value>
        /// The patient lab detail identifier.
        /// </value>
        public int? PatientLabDetailId { get; set; }

        /// <summary>
        /// Gets or sets the charges set.
        /// </summary>
        /// <value>
        /// The charges set.
        /// </value>
        public bool? ChargesSet { get; set; }

        /// <summary>
        /// Gets or sets from source.
        /// </summary>
        /// <value>
        /// From source.
        /// </value>
        public string FromSource { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is from bill.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is from bill; otherwise, <c>false</c>.
        /// </value>
        public bool IsFromBill { get; set; }

        /// <summary>
        /// Gets or sets the charge category identifier.
        /// </summary>
        /// <value>
        /// The charge category identifier.
        /// </value>
        public int? ChargeCategoryId { get; set; }

        /// <summary>
        /// Gets or sets the sample usage.
        /// </summary>
        /// <value>
        /// The sample usage.
        /// </value>
        public string SampleUsage { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether [nabl required].
        /// </summary>
        /// <value>
        ///   <c>true</c> if [nabl required]; otherwise, <c>false</c>.
        /// </value>
        public bool? NablRequired { get; set; }

        /// <summary>
        /// Gets or sets the consent form required.
        /// </summary>
        /// <value>
        /// The consent form required.
        /// </value>
        public bool? ConsentFormRequired { get; set; }

        /// <summary>
        /// Gets or sets the assign doctor required.
        /// </summary>
        /// <value>
        /// The assign doctor required.
        /// </value>
        public bool? AssignDoctorRequired { get; set; }

        /// <summary>
        /// Gets or sets the role identifier.
        /// </summary>
        /// <value>
        /// The role identifier.
        /// </value>
        public int RoleId { get; set; }

        /// <summary>
        /// Gets or sets the lab vacutainer identifier.
        /// </summary>
        /// <value>
        /// The lab vacutainer identifier.
        /// </value>
        public int? LabVacutainerId { get; set; }

        /// <summary>
        /// Gets or sets the name of the lab vacutainer.
        /// </summary>
        /// <value>
        /// The name of the lab vacutainer.
        /// </value>
        public string LabVacutainerName { get; set; }

        /// <summary>
        /// Gets or sets the no of samples collect.
        /// </summary>
        /// <value>
        /// The no of samples collect.
        /// </value>
        public int? NoOfSamplesCollect { get; set; }

        /// <summary>
        /// Gets or sets the no of samples collect text.
        /// </summary>
        /// <value>
        /// The no of samples collect text.
        /// </value>
        public string NoOfSamplesCollectText { get; set; }

        public string? DepartmentType { get; set; }

        public string? SampleType { get; set; }

        public string? TypeOfLab { get; set; }

        /// <summary>
        /// Gets or sets the test precaution.
        /// </summary>
        /// <value>
        /// The test precaution.
        /// </value>
        public string TestPrecaution { get; set; }
    }

    /// <summary>
    /// The lab main detail template model.
    /// </summary>
    public class LabMainDetailTemplateModel
    {
        /// <summary>
        /// Gets or sets the lab main detail template identifier.
        /// </summary>
        /// <value>
        /// The lab main detail template identifier.
        /// </value>
        public long LabMainDetailTemplateId { get; set; }

        /// <summary>
        /// Gets or sets the lab main detail identifier.
        /// </summary>
        /// <value>
        /// The lab main detail identifier.
        /// </value>
        public int LabMainDetailId { get; set; }

        /// <summary>
        /// Gets or sets the lab template header identifier.
        /// </summary>
        /// <value>
        /// The lab template header identifier.
        /// </value>
        public int LabTemplateHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the priority.
        /// </summary>
        /// <value>
        /// The priority.
        /// </value>
        public int Priority { get; set; }

        /// <summary>
        /// Gets or sets the name of the template.
        /// </summary>
        /// <value>
        /// The name of the template.
        /// </value>
        public string TemplateName { get; set; }

        /// <summary>
        /// Gets or sets the template identifier.
        /// </summary>
        /// <value>
        /// The template identifier.
        /// </value>
        public string TemplateId { get; set; }



    }
}
