﻿namespace Hims.Domain.Entities
{
    using Hims.Shared.Dapper.Attributes;
    using System;
    using System.ComponentModel.DataAnnotations;

    /// <summary>
    /// The appointment types
    /// </summary>

    public class AppointmentType
{
        /// <summary>
        /// Gets or sets the appointment type.
        /// </summary>
        /// <value>
        /// The appointment type.
        /// </value>
        [Key, Identity]
        public int AppointmentTypeId { get; set; }

        /// <summary>
        /// Gets or sets the name of the appointment.
        /// </summary>
        /// <value>
        /// The name of the appointment.
        /// </value>
        public string Name { get; set; }
      
        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        [IgnoreUpdate]
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        [IgnoreUpdate]
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        /// <value>
        /// The modified by.
        /// </value>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        /// <value>
        /// The modified date.
        /// </value>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the color of the row.
        /// </summary>
        /// <value>
        /// The color of the row.
        /// </value>
        public string RowColor { get; set; }
    }
}
